/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.LongSupplier;
import java.util.function.Supplier;
import reactor.core.publisher.AtomicSequence;
import reactor.core.publisher.MultiProducerRingBuffer;
import reactor.core.publisher.NotFunMultiProducer;
import reactor.core.publisher.NotFunRingBuffer;
import reactor.core.publisher.RingBufferProducer;
import reactor.core.publisher.SingleProducerSequencer;
import reactor.core.publisher.UnsafeRingBuffer;
import reactor.core.publisher.UnsafeSequence;
import reactor.core.publisher.UnsafeSupport;
import reactor.util.concurrent.QueueSupplier;
import reactor.util.concurrent.WaitStrategy;

abstract class RingBuffer<E>
implements LongSupplier {
    public static final long INITIAL_CURSOR_VALUE = -1L;
    private static final boolean HAS_UNSAFE = RingBuffer.hasUnsafe0();

    RingBuffer() {
    }

    public static <E> RingBuffer<E> createMultiProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        return RingBuffer.createMultiProducer(factory, bufferSize, waitStrategy, null);
    }

    public static <E> RingBuffer<E> createMultiProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        if (RingBuffer.hasUnsafe() && QueueSupplier.isPowerOfTwo(bufferSize)) {
            MultiProducerRingBuffer sequencer = new MultiProducerRingBuffer(bufferSize, waitStrategy, spinObserver);
            return new UnsafeRingBuffer<E>(factory, sequencer);
        }
        NotFunMultiProducer sequencer = new NotFunMultiProducer(bufferSize, waitStrategy, spinObserver);
        return new NotFunRingBuffer<E>(factory, sequencer);
    }

    public static <E> RingBuffer<E> createSingleProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy) {
        return RingBuffer.createSingleProducer(factory, bufferSize, waitStrategy, null);
    }

    public static <E> RingBuffer<E> createSingleProducer(Supplier<E> factory, int bufferSize, WaitStrategy waitStrategy, Runnable spinObserver) {
        SingleProducerSequencer sequencer = new SingleProducerSequencer(bufferSize, waitStrategy, spinObserver);
        if (RingBuffer.hasUnsafe() && QueueSupplier.isPowerOfTwo(bufferSize)) {
            return new UnsafeRingBuffer<E>(factory, sequencer);
        }
        return new NotFunRingBuffer<E>(factory, sequencer);
    }

    public static long getMinimumSequence(Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            long value = sequences[i].getAsLong();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    public static long getMinimumSequence(Sequence excludeSequence, Sequence[] sequences, long minimum) {
        int n = sequences.length;
        for (int i = 0; i < n; ++i) {
            if (excludeSequence != null && sequences[i] == excludeSequence) continue;
            long value = sequences[i].getAsLong();
            minimum = Math.min(minimum, value);
        }
        return minimum;
    }

    static <T> T getUnsafe() {
        return (T)UnsafeSupport.getUnsafe();
    }

    public static int log2(int i) {
        int r = 0;
        while ((i >>= 1) != 0) {
            ++r;
        }
        return r;
    }

    public static Sequence newSequence(long init) {
        if (RingBuffer.hasUnsafe()) {
            return new UnsafeSequence(init);
        }
        return new AtomicSequence(init);
    }

    public abstract void addGatingSequence(Sequence var1);

    public abstract int bufferSize();

    public abstract E get(long var1);

    @Override
    public long getAsLong() {
        return this.getCursor();
    }

    public abstract long getCursor();

    public abstract long getMinimumGatingSequence();

    public abstract long getMinimumGatingSequence(Sequence var1);

    public abstract int getPending();

    public abstract Sequence getSequence();

    public Sequence[] getSequenceReceivers() {
        return this.getSequencer().getGatingSequences();
    }

    public abstract Reader newReader();

    public abstract long next();

    public abstract long next(int var1);

    public abstract void publish(long var1);

    public abstract void publish(long var1, long var3);

    public abstract long remainingCapacity();

    public abstract boolean removeGatingSequence(Sequence var1);

    public String toString() {
        return "RingBuffer{remaining size:" + this.remainingCapacity() + ", size:" + this.bufferSize() + ", cursor:" + this.getAsLong() + ", min:" + this.getMinimumGatingSequence() + ", subscribers:" + this.getSequencer().gatingSequences.length + "}";
    }

    abstract RingBufferProducer getSequencer();

    static boolean hasUnsafe() {
        return HAS_UNSAFE;
    }

    static boolean hasUnsafe0() {
        try {
            return !RingBuffer.isAndroid() && UnsafeSupport.hasUnsafe();
        }
        catch (Throwable t) {
            return false;
        }
    }

    static boolean isAndroid() {
        try {
            Class.forName("android.app.Application", false, UnsafeSupport.getSystemClassLoader());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static final class Reader
    implements Runnable,
    LongSupplier {
        private final WaitStrategy waitStrategy;
        private volatile boolean alerted = false;
        private final Sequence cursorSequence;
        private final RingBufferProducer sequenceProducer;

        Reader(RingBufferProducer sequenceProducer, WaitStrategy waitStrategy, Sequence cursorSequence) {
            this.sequenceProducer = sequenceProducer;
            this.waitStrategy = waitStrategy;
            this.cursorSequence = cursorSequence;
        }

        public long waitFor(long sequence) throws InterruptedException {
            this.checkAlert();
            long availableSequence = this.waitStrategy.waitFor(sequence, this.cursorSequence, this);
            if (availableSequence < sequence) {
                return availableSequence;
            }
            return this.sequenceProducer.getHighestPublishedSequence(sequence, availableSequence);
        }

        public long waitFor(long sequence, Runnable consumer) throws InterruptedException {
            this.checkAlert();
            long availableSequence = this.waitStrategy.waitFor(sequence, this.cursorSequence, consumer);
            if (availableSequence < sequence) {
                return availableSequence;
            }
            return this.sequenceProducer.getHighestPublishedSequence(sequence, availableSequence);
        }

        public long getCursor() {
            return this.cursorSequence.getAsLong();
        }

        public boolean isAlerted() {
            return this.alerted;
        }

        public void alert() {
            this.alerted = true;
            this.waitStrategy.signalAllWhenBlocking();
        }

        public void signal() {
            this.waitStrategy.signalAllWhenBlocking();
        }

        public void clearAlert() {
            this.alerted = false;
        }

        public void checkAlert() {
            if (this.alerted) {
                WaitStrategy.alert();
            }
        }

        @Override
        public long getAsLong() {
            return this.cursorSequence.getAsLong();
        }

        @Override
        public void run() {
            this.checkAlert();
        }
    }

    public static interface Sequence
    extends LongSupplier {
        public static final long INITIAL_VALUE = -1L;

        @Override
        public long getAsLong();

        public void set(long var1);

        public void setVolatile(long var1);

        public boolean compareAndSet(long var1, long var3);

        public long incrementAndGet();

        public long addAndGet(long var1);
    }
}

