/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelUnorderedSource<T>
extends ParallelFlux<T> {
    final Publisher<? extends T> source;
    final int parallelism;
    final int prefetch;
    final Supplier<Queue<T>> queueSupplier;

    public ParallelUnorderedSource(Publisher<? extends T> source, int parallelism, int prefetch, Supplier<Queue<T>> queueSupplier) {
        this.source = source;
        this.parallelism = parallelism;
        this.prefetch = prefetch;
        this.queueSupplier = queueSupplier;
    }

    @Override
    public int parallelism() {
        return this.parallelism;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        this.source.subscribe(new ParallelDispatcher<T>(subscribers, this.prefetch, this.queueSupplier));
    }

    static final class ParallelDispatcher<T>
    implements Subscriber<T> {
        final Subscriber<? super T>[] subscribers;
        final AtomicLongArray requests;
        final long[] emissions;
        final int prefetch;
        final int limit;
        final Supplier<Queue<T>> queueSupplier;
        Subscription s;
        Queue<T> queue;
        Throwable error;
        volatile boolean done;
        int index;
        volatile boolean cancelled;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<ParallelDispatcher> WIP = AtomicIntegerFieldUpdater.newUpdater(ParallelDispatcher.class, "wip");
        volatile int subscriberCount;
        static final AtomicIntegerFieldUpdater<ParallelDispatcher> SUBSCRIBER_COUNT = AtomicIntegerFieldUpdater.newUpdater(ParallelDispatcher.class, "subscriberCount");
        int produced;
        int sourceMode;

        public ParallelDispatcher(Subscriber<? super T>[] subscribers, int prefetch, Supplier<Queue<T>> queueSupplier) {
            this.subscribers = subscribers;
            this.prefetch = prefetch;
            this.queueSupplier = queueSupplier;
            this.limit = prefetch - (prefetch >> 2);
            this.requests = new AtomicLongArray(subscribers.length);
            this.emissions = new long[subscribers.length];
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.setupSubscribers();
                        this.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = m;
                        this.queue = qs;
                        this.setupSubscribers();
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                this.queue = this.queueSupplier.get();
                this.setupSubscribers();
                s.request((long)this.prefetch);
            }
        }

        void setupSubscribers() {
            final int m = this.subscribers.length;
            for (int i = 0; i < m; ++i) {
                if (this.cancelled) {
                    return;
                }
                final int j = i;
                SUBSCRIBER_COUNT.lazySet(this, i + 1);
                this.subscribers[i].onSubscribe(new Subscription(){

                    public void request(long n) {
                        if (Operators.validate(n)) {
                            long u;
                            long r;
                            AtomicLongArray ra = requests;
                            do {
                                if ((r = ra.get(j)) != Long.MAX_VALUE) continue;
                                return;
                            } while (!ra.compareAndSet(j, r, u = Operators.addCap(r, n)));
                            if (subscriberCount == m) {
                                this.drain();
                            }
                        }
                    }

                    public void cancel() {
                        this.cancel();
                    }
                });
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            if (this.sourceMode == 0 && !this.queue.offer(t)) {
                this.cancel();
                this.onError(Exceptions.failWithOverflow("Queue is full?"));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    this.queue.clear();
                }
            }
        }

        void drainAsync() {
            int missed = 1;
            Queue<T> q = this.queue;
            Subscriber<? super T>[] a = this.subscribers;
            AtomicLongArray r = this.requests;
            long[] e = this.emissions;
            int n = e.length;
            int idx = this.index;
            int consumed = this.produced;
            while (true) {
                int w;
                int notReady = 0;
                do {
                    long eidx;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (d && (ex = this.error) != null) {
                        q.clear();
                        for (Subscriber<? super T> s : a) {
                            s.onError(ex);
                        }
                        return;
                    }
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        for (Subscriber<? super T> s : a) {
                            s.onComplete();
                        }
                        return;
                    }
                    if (empty) break;
                    long ridx = r.get(idx);
                    if (ridx != (eidx = e[idx])) {
                        T v;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex2) {
                            ex2 = Operators.onOperatorError(this.s, ex2);
                            for (Subscriber<? super T> s : a) {
                                s.onError(ex2);
                            }
                            return;
                        }
                        if (v == null) break;
                        a[idx].onNext(v);
                        e[idx] = eidx + 1L;
                        int c = ++consumed;
                        if (c == this.limit) {
                            consumed = 0;
                            this.s.request((long)c);
                        }
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n) continue;
                    idx = 0;
                } while (notReady != n);
                if ((w = this.wip) == missed) {
                    this.index = idx;
                    this.produced = consumed;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void drainSync() {
            int missed = 1;
            Queue<T> q = this.queue;
            Subscriber<? super T>[] a = this.subscribers;
            AtomicLongArray r = this.requests;
            long[] e = this.emissions;
            int n = e.length;
            int idx = this.index;
            while (true) {
                int notReady = 0;
                do {
                    long eidx;
                    boolean empty;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    try {
                        empty = q.isEmpty();
                    }
                    catch (Throwable ex) {
                        ex = Operators.onOperatorError(this.s, ex);
                        for (Subscriber<? super T> s : a) {
                            s.onError(ex);
                        }
                        return;
                    }
                    if (empty) {
                        for (Subscriber<? super T> s : a) {
                            s.onComplete();
                        }
                        return;
                    }
                    long ridx = r.get(idx);
                    if (ridx != (eidx = e[idx])) {
                        T v;
                        try {
                            v = q.poll();
                        }
                        catch (Throwable ex) {
                            ex = Operators.onOperatorError(this.s, ex);
                            for (Subscriber<? super T> s : a) {
                                s.onError(ex);
                            }
                            return;
                        }
                        if (v == null) {
                            for (Subscriber<? super T> s : a) {
                                s.onComplete();
                            }
                            return;
                        }
                        a[idx].onNext(v);
                        e[idx] = eidx + 1L;
                        notReady = 0;
                    } else {
                        ++notReady;
                    }
                    if (++idx != n) continue;
                    idx = 0;
                } while (notReady != n);
                int w = this.wip;
                if (w == missed) {
                    this.index = idx;
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.sourceMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }
    }
}

