/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxPublishOn;
import reactor.core.publisher.ParallelFlux;
import reactor.core.scheduler.Scheduler;

final class ParallelUnorderedRunOn<T>
extends ParallelFlux<T>
implements Fuseable {
    final ParallelFlux<? extends T> source;
    final Scheduler scheduler;
    final int prefetch;
    final Supplier<Queue<T>> queueSupplier;

    public ParallelUnorderedRunOn(ParallelFlux<? extends T> parent, Scheduler scheduler, int prefetch, Supplier<Queue<T>> queueSupplier) {
        this.source = parent;
        this.scheduler = scheduler;
        this.prefetch = prefetch;
        this.queueSupplier = queueSupplier;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            FluxPublishOn.PublishOnSubscriber<? super T> parent;
            Subscriber<? super T> a = subscribers[i];
            Scheduler.Worker w = this.scheduler.createWorker();
            parents[i] = parent = new FluxPublishOn.PublishOnSubscriber<T>(a, this.scheduler, w, true, this.prefetch, this.queueSupplier);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public boolean isOrdered() {
        return this.source.isOrdered();
    }
}

