/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelUnorderedJoin<T>
extends Flux<T> {
    final ParallelFlux<? extends T> source;
    final int prefetch;
    final Supplier<Queue<T>> queueSupplier;

    public ParallelUnorderedJoin(ParallelFlux<? extends T> source, int prefetch, Supplier<Queue<T>> queueSupplier) {
        this.source = source;
        this.prefetch = prefetch;
        this.queueSupplier = queueSupplier;
    }

    public void subscribe(Subscriber<? super T> s) {
        JoinSubscription<? super T> parent = new JoinSubscription<T>(s, this.source.parallelism(), this.prefetch, this.queueSupplier);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class JoinInnerSubscriber<T>
    implements Subscriber<T> {
        final JoinSubscription<T> parent;
        final int prefetch;
        final int limit;
        long produced;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<JoinInnerSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(JoinInnerSubscriber.class, Subscription.class, "s");
        volatile Queue<T> queue;
        volatile boolean done;

        public JoinInnerSubscriber(JoinSubscription<T> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            this.parent.onNext(this, t);
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.onComplete();
        }

        public void requestOne() {
            long p = this.produced + 1L;
            if (p == (long)this.limit) {
                this.produced = 0L;
                this.s.request(p);
            } else {
                this.produced = p;
            }
        }

        public void request(long n) {
            long p = this.produced + n;
            if (p >= (long)this.limit) {
                this.produced = 0L;
                this.s.request(p);
            } else {
                this.produced = p;
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }

        Queue<T> getQueue(Supplier<Queue<T>> queueSupplier) {
            Queue<T> q = this.queue;
            if (q == null) {
                this.queue = q = queueSupplier.get();
            }
            return q;
        }
    }

    static final class JoinSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final JoinInnerSubscriber<T>[] subscribers;
        final Supplier<Queue<T>> queueSupplier;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<JoinSubscription, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(JoinSubscription.class, Throwable.class, "error");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<JoinSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(JoinSubscription.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<JoinSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(JoinSubscription.class, "requested");
        volatile boolean cancelled;
        volatile int done;
        static final AtomicIntegerFieldUpdater<JoinSubscription> DONE = AtomicIntegerFieldUpdater.newUpdater(JoinSubscription.class, "done");

        public JoinSubscription(Subscriber<? super T> actual, int n, int prefetch, Supplier<Queue<T>> queueSupplier) {
            this.actual = actual;
            this.queueSupplier = queueSupplier;
            JoinInnerSubscriber[] a = new JoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                a[i] = new JoinInnerSubscriber(this, prefetch);
            }
            this.subscribers = a;
            DONE.lazySet(this, n);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (WIP.getAndIncrement(this) == 0) {
                    this.cleanup();
                }
            }
        }

        void cancelAll() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void cleanup() {
            for (JoinInnerSubscriber<T> s : this.subscribers) {
                s.queue = null;
            }
        }

        void onNext(JoinInnerSubscriber<T> inner, T value) {
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                if (this.requested != 0L) {
                    this.actual.onNext(value);
                    if (this.requested != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                    inner.request(1L);
                } else {
                    Queue<T> q = inner.getQueue(this.queueSupplier);
                    q.offer(value);
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
            } else {
                Queue<T> q = inner.getQueue(this.queueSupplier);
                q.offer(value);
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        void onError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.cancelAll();
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void onComplete() {
            if (DONE.decrementAndGet(this) < 0) {
                return;
            }
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            int missed = 1;
            JoinInnerSubscriber<T>[] s = this.subscribers;
            int n = s.length;
            Subscriber<? super T> a = this.actual;
            while (true) {
                int w;
                Queue q;
                JoinInnerSubscriber<T> inner;
                int i;
                boolean empty;
                boolean d;
                Throwable ex;
                long r = this.requested;
                long e = 0L;
                block1: while (e != r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = this.error;
                    if (ex != null) {
                        ex = Exceptions.terminate(ERROR, this);
                        this.cleanup();
                        a.onError(ex);
                        return;
                    }
                    d = this.done == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        Object v;
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || (v = q.poll()) == null) continue;
                        empty = false;
                        a.onNext(v);
                        inner.requestOne();
                        if (++e == r) break block1;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (!empty) continue;
                    break;
                }
                if (e == r) {
                    if (this.cancelled) {
                        this.cleanup();
                        return;
                    }
                    ex = this.error;
                    if (ex != null) {
                        ex = Exceptions.terminate(ERROR, this);
                        this.cleanup();
                        a.onError(ex);
                        return;
                    }
                    d = this.done == 0;
                    empty = true;
                    for (i = 0; i < n; ++i) {
                        inner = s[i];
                        q = inner.queue;
                        if (q == null || q.isEmpty()) continue;
                        empty = false;
                        break;
                    }
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    REQUESTED.addAndGet(this, -e);
                }
                if ((w = this.wip) == missed) {
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }
}

