/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxFilter;
import reactor.core.publisher.ParallelFlux;

final class ParallelUnorderedFilter<T>
extends ParallelFlux<T> {
    final ParallelFlux<T> source;
    final Predicate<? super T> predicate;

    public ParallelUnorderedFilter(ParallelFlux<T> source, Predicate<? super T> predicate) {
        this.source = source;
        this.predicate = predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = new FluxFilter.FilterSubscriber<T>(subscribers[i], this.predicate);
        }
        this.source.subscribe(parents);
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }
}

