/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelSortedJoin<T>
extends Flux<T> {
    final ParallelFlux<List<T>> source;
    final Comparator<? super T> comparator;

    public ParallelSortedJoin(ParallelFlux<List<T>> source, Comparator<? super T> comparator) {
        this.source = source;
        this.comparator = comparator;
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    public void subscribe(Subscriber<? super T> s) {
        SortedJoinSubscription<? super T> parent = new SortedJoinSubscription<T>(s, this.source.parallelism(), this.comparator);
        s.onSubscribe(parent);
        this.source.subscribe(parent.subscribers);
    }

    static final class SortedJoinInnerSubscriber<T>
    implements Subscriber<List<T>> {
        final SortedJoinSubscription<T> parent;
        final int index;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<SortedJoinInnerSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SortedJoinInnerSubscriber.class, Subscription.class, "s");

        public SortedJoinInnerSubscriber(SortedJoinSubscription<T> parent, int index) {
            this.parent = parent;
            this.index = index;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(List<T> t) {
            this.parent.innerNext(t, this.index);
        }

        public void onError(Throwable t) {
            this.parent.innerError(t);
        }

        public void onComplete() {
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class SortedJoinSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final SortedJoinInnerSubscriber<T>[] subscribers;
        final List<T>[] lists;
        final int[] indexes;
        final Comparator<? super T> comparator;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<SortedJoinSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(SortedJoinSubscription.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<SortedJoinSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(SortedJoinSubscription.class, "requested");
        volatile boolean cancelled;
        volatile int remaining;
        static final AtomicIntegerFieldUpdater<SortedJoinSubscription> REMAINING = AtomicIntegerFieldUpdater.newUpdater(SortedJoinSubscription.class, "remaining");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<SortedJoinSubscription, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(SortedJoinSubscription.class, Throwable.class, "error");

        public SortedJoinSubscription(Subscriber<? super T> actual, int n, Comparator<? super T> comparator) {
            this.actual = actual;
            this.comparator = comparator;
            SortedJoinInnerSubscriber[] s = new SortedJoinInnerSubscriber[n];
            for (int i = 0; i < n; ++i) {
                s[i] = new SortedJoinInnerSubscriber(this, i);
            }
            this.subscribers = s;
            this.lists = new List[n];
            this.indexes = new int[n];
            REMAINING.lazySet(this, n);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                if (this.remaining == 0) {
                    this.drain();
                }
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.cancelAll();
                if (WIP.getAndIncrement(this) == 0) {
                    Arrays.fill(this.lists, null);
                }
            }
        }

        void cancelAll() {
            for (SortedJoinInnerSubscriber<T> s : this.subscribers) {
                s.cancel();
            }
        }

        void innerNext(List<T> value, int index) {
            this.lists[index] = value;
            if (REMAINING.decrementAndGet(this) == 0) {
                this.drain();
            }
        }

        void innerError(Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            Subscriber<? super T> a = this.actual;
            Object[] lists = this.lists;
            int[] indexes = this.indexes;
            int n = indexes.length;
            while (true) {
                int w;
                Throwable ex;
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = this.error;
                    if (ex != null) {
                        ex = Exceptions.terminate(ERROR, this);
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a.onError(ex);
                        return;
                    }
                    Object min = null;
                    int minIndex = -1;
                    for (int i = 0; i < n; ++i) {
                        Object list = lists[i];
                        int index = indexes[i];
                        if (list.size() == index) continue;
                        if (min == null) {
                            min = list.get(index);
                            minIndex = i;
                            continue;
                        }
                        Object b = list.get(index);
                        if (this.comparator.compare(min, b) <= 0) continue;
                        min = b;
                        minIndex = i;
                    }
                    if (min == null) {
                        Arrays.fill(lists, null);
                        a.onComplete();
                        return;
                    }
                    a.onNext(min);
                    int n2 = minIndex;
                    indexes[n2] = indexes[n2] + 1;
                }
                if (e == r) {
                    if (this.cancelled) {
                        Arrays.fill(lists, null);
                        return;
                    }
                    ex = this.error;
                    if (ex != null) {
                        ex = Exceptions.terminate(ERROR, this);
                        this.cancelAll();
                        Arrays.fill(lists, null);
                        a.onError(ex);
                        return;
                    }
                    boolean empty = true;
                    for (int i = 0; i < n; ++i) {
                        if (indexes[i] == lists[i].size()) continue;
                        empty = false;
                        break;
                    }
                    if (empty) {
                        Arrays.fill(lists, null);
                        a.onComplete();
                        return;
                    }
                }
                if (e != 0L && r != Long.MAX_VALUE) {
                    REQUESTED.addAndGet(this, -e);
                }
                if ((w = this.wip) == missed) {
                    if ((missed = WIP.addAndGet(this, -missed)) != 0) continue;
                    break;
                }
                missed = w;
            }
        }
    }
}

