/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.ParallelFlux;

final class ParallelFluxOnAssembly<T>
extends ParallelFlux<T>
implements Fuseable,
AssemblyOp,
Receiver {
    final ParallelFlux<T> source;
    final String stacktrace;

    public ParallelFluxOnAssembly(ParallelFlux<T> source, boolean trace) {
        this.source = source;
        this.stacktrace = trace ? FluxOnAssembly.takeStacktrace(source) : null;
    }

    @Override
    public boolean isOrdered() {
        return this.source.isOrdered();
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super T>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            Subscriber<? super T> s = subscribers[i];
            if (this.stacktrace != null) {
                if (s instanceof Fuseable.ConditionalSubscriber) {
                    Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                    s = new FluxOnAssembly.OnAssemblyConditionalSubscriber<T>(cs, this.stacktrace, (Publisher<?>)this.source);
                } else {
                    s = new FluxOnAssembly.OnAssemblySubscriber<T>(s, this.stacktrace, this.source);
                }
            }
            parents[i] = s;
        }
        this.source.subscribe(parents);
    }

    @Override
    public Object upstream() {
        return this.source;
    }
}

