/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Queue;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.ParallelFlux;

final class ParallelFlatMap<T, R>
extends ParallelFlux<R> {
    final ParallelFlux<T> source;
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final boolean delayError;
    final int maxConcurrency;
    final Supplier<? extends Queue<R>> mainQueueSupplier;
    final int prefetch;
    final Supplier<? extends Queue<R>> innerQueueSupplier;

    public ParallelFlatMap(ParallelFlux<T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, Supplier<? extends Queue<R>> mainQueueSupplier, int prefetch, Supplier<? extends Queue<R>> innerQueueSupplier) {
        this.source = source;
        this.mapper = mapper;
        this.delayError = delayError;
        this.maxConcurrency = maxConcurrency;
        this.mainQueueSupplier = mainQueueSupplier;
        this.prefetch = prefetch;
        this.innerQueueSupplier = innerQueueSupplier;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            parents[i] = FluxFlatMap.subscriber(subscribers[i], this.mapper, this.delayError, this.maxConcurrency, this.mainQueueSupplier, this.prefetch, this.innerQueueSupplier);
        }
        this.source.subscribe(parents);
    }
}

