/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.Operators;
import reactor.core.publisher.ParallelFlux;

final class ParallelCollect<T, C>
extends ParallelFlux<C>
implements Fuseable {
    final ParallelFlux<? extends T> source;
    final Supplier<C> initialCollection;
    final BiConsumer<C, T> collector;

    public ParallelCollect(ParallelFlux<? extends T> source, Supplier<C> initialCollection, BiConsumer<C, T> collector) {
        this.source = source;
        this.initialCollection = initialCollection;
        this.collector = collector;
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super C>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            C initialValue;
            try {
                initialValue = this.initialCollection.get();
            }
            catch (Throwable ex) {
                this.reportError(subscribers, Operators.onOperatorError(ex));
                return;
            }
            if (initialValue == null) {
                this.reportError(subscribers, new NullPointerException("The initialSupplier returned a null value"));
                return;
            }
            parents[i] = new ParallelCollectSubscriber<T, C>(subscribers[i], initialValue, this.collector);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            Operators.error(s, ex);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    static final class ParallelCollectSubscriber<T, C>
    extends Operators.MonoSubscriber<T, C> {
        final BiConsumer<C, T> collector;
        C collection;
        Subscription s;
        boolean done;

        public ParallelCollectSubscriber(Subscriber<? super C> subscriber, C initialValue, BiConsumer<C, T> collector) {
            super(subscriber);
            this.collection = initialValue;
            this.collector = collector;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.collector.accept(this.collection, t);
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this, ex, t));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.collection = null;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            C c = this.collection;
            this.collection = null;
            this.complete(c);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }
    }
}

