/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Supplier;
import reactor.core.publisher.RingBuffer;
import reactor.core.publisher.RingBufferProducer;

abstract class NotFunRingBufferFields<E>
extends RingBuffer<E> {
    private final long indexMask;
    private final Object[] entries;
    protected final int bufferSize;
    protected final RingBufferProducer sequenceProducer;

    NotFunRingBufferFields(Supplier<E> eventFactory, RingBufferProducer sequenceProducer) {
        this.sequenceProducer = sequenceProducer;
        this.bufferSize = sequenceProducer.getBufferSize();
        if (this.bufferSize < 1) {
            throw new IllegalArgumentException("bufferSize must not be less than 1");
        }
        this.indexMask = this.bufferSize - 1;
        this.entries = new Object[sequenceProducer.getBufferSize()];
        this.fill(eventFactory);
    }

    private void fill(Supplier<E> eventFactory) {
        for (int i = 0; i < this.bufferSize; ++i) {
            this.entries[i] = eventFactory.get();
        }
    }

    protected final E elementAt(long sequence) {
        return (E)this.entries[(int)(sequence & this.indexMask)];
    }
}

