/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxFlatMap;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoThenMap<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final Function<? super T, ? extends Mono<? extends R>> mapper;

    public MonoThenMap(Publisher<? extends T> source, Function<? super T, ? extends Mono<? extends R>> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, true)) {
            return;
        }
        MonoThenApplyMain<? super T, ? super R> manager = new MonoThenApplyMain<T, R>(s, this.mapper);
        s.onSubscribe(manager);
        this.source.subscribe(manager);
    }

    static final class MonoThenApplyMain<T, R>
    extends Operators.MonoSubscriber<T, R> {
        final Function<? super T, ? extends Mono<? extends R>> mapper;
        final SecondSubscriber<R> second;
        boolean done;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<MonoThenApplyMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(MonoThenApplyMain.class, Subscription.class, "s");

        public MonoThenApplyMain(Subscriber<? super R> subscriber, Function<? super T, ? extends Mono<? extends R>> mapper) {
            super(subscriber);
            this.mapper = mapper;
            this.second = new SecondSubscriber(this);
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            Mono<? extends R> m;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.done = true;
            try {
                m = this.mapper.apply(t);
            }
            catch (Throwable ex) {
                this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                return;
            }
            if (m == null) {
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null Mono"), t));
                return;
            }
            if (m instanceof Callable) {
                Object v;
                Callable c = (Callable)((Object)m);
                try {
                    v = c.call();
                }
                catch (Throwable ex) {
                    this.actual.onError(Operators.onOperatorError(this.s, ex, t));
                    return;
                }
                if (v == null) {
                    this.actual.onComplete();
                } else {
                    this.complete(v);
                }
                return;
            }
            try {
                m.subscribe(this.second);
            }
            catch (Throwable e) {
                this.actual.onError(Operators.onOperatorError(this, e, t));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public void cancel() {
            super.cancel();
            Operators.terminate(S, this);
            this.second.cancel();
        }

        void secondError(Throwable ex) {
            this.actual.onError(ex);
        }

        void secondComplete() {
            this.actual.onComplete();
        }

        static final class SecondSubscriber<R>
        implements Subscriber<R> {
            final MonoThenApplyMain<?, R> parent;
            volatile Subscription s;
            static final AtomicReferenceFieldUpdater<SecondSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(SecondSubscriber.class, Subscription.class, "s");
            boolean done;

            public SecondSubscriber(MonoThenApplyMain<?, R> parent) {
                this.parent = parent;
            }

            public void onSubscribe(Subscription s) {
                if (Operators.setOnce(S, this, s)) {
                    s.request(Long.MAX_VALUE);
                }
            }

            public void onNext(R t) {
                if (this.done) {
                    Operators.onNextDropped(t);
                    return;
                }
                this.done = true;
                this.parent.complete(t);
            }

            public void onError(Throwable t) {
                if (this.done) {
                    Operators.onErrorDropped(t);
                    return;
                }
                this.done = true;
                this.parent.secondError(t);
            }

            public void onComplete() {
                if (this.done) {
                    return;
                }
                this.done = true;
                this.parent.secondComplete();
            }

            void cancel() {
                Operators.terminate(S, this);
            }
        }
    }
}

