/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.MultiReceiver;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoThenIgnore<T>
extends Mono<T>
implements Fuseable,
MultiReceiver {
    final Mono<?>[] ignore;
    final Mono<T> last;

    public MonoThenIgnore(Mono<?>[] ignore, Mono<T> last) {
        this.ignore = Objects.requireNonNull(ignore, "ignore");
        this.last = Objects.requireNonNull(last, "last");
    }

    public void subscribe(Subscriber<? super T> s) {
        MonoThenIgnoreMain<T> manager = new MonoThenIgnoreMain<T>(s, this.ignore, this.last);
        s.onSubscribe(manager);
        manager.drain();
    }

    @Override
    public Iterator<?> upstreams() {
        List<Mono<?>> r = Arrays.asList(this.ignore);
        r.add(this.last);
        return r.iterator();
    }

    @Override
    public long upstreamCount() {
        return this.ignore.length + 1;
    }

    public <U> MonoThenIgnore<U> shift(Mono<U> newLast) {
        Objects.requireNonNull(newLast, "newLast");
        Mono<?>[] a = this.ignore;
        int n = a.length;
        Mono[] b = new Mono[n + 1];
        System.arraycopy(a, 0, b, 0, n);
        b[n] = this.last;
        return new MonoThenIgnore<U>(b, newLast);
    }

    static final class MonoThenAcceptSubscriber<T>
    implements Subscriber<T> {
        final MonoThenIgnoreMain<T> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<MonoThenAcceptSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(MonoThenAcceptSubscriber.class, Subscription.class, "s");
        boolean done;

        public MonoThenAcceptSubscriber(MonoThenIgnoreMain<T> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            this.done = true;
            this.parent.complete(t);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.parent.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.parent.onComplete();
        }

        void cancel() {
            Operators.terminate(S, this);
        }
    }

    static final class MonoThenIgnoreSubscriber
    implements Subscriber<Object> {
        final MonoThenIgnoreMain<?> parent;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<MonoThenIgnoreSubscriber, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(MonoThenIgnoreSubscriber.class, Subscription.class, "s");

        public MonoThenIgnoreSubscriber(MonoThenIgnoreMain<?> parent) {
            this.parent = parent;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.replace(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(Object t) {
        }

        public void onError(Throwable t) {
            this.parent.onError(t);
        }

        public void onComplete() {
            this.parent.ignoreDone();
        }

        void cancel() {
            Operators.terminate(S, this);
        }

        void clear() {
            S.lazySet(this, null);
        }
    }

    static final class MonoThenIgnoreMain<T>
    extends Operators.MonoSubscriber<T, T> {
        final MonoThenIgnoreSubscriber ignore;
        final MonoThenAcceptSubscriber<T> accept;
        final Mono<?>[] ignoreMonos;
        final Mono<T> lastMono;
        int index;
        volatile boolean active;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<MonoThenIgnoreMain> WIP = AtomicIntegerFieldUpdater.newUpdater(MonoThenIgnoreMain.class, "wip");

        public MonoThenIgnoreMain(Subscriber<? super T> subscriber, Mono<?>[] ignoreMonos, Mono<T> lastMono) {
            super(subscriber);
            this.ignoreMonos = ignoreMonos;
            this.lastMono = lastMono;
            this.ignore = new MonoThenIgnoreSubscriber(this);
            this.accept = new MonoThenAcceptSubscriber(this);
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            while (true) {
                if (this.isCancelled()) {
                    return;
                }
                if (!this.active) {
                    Mono<Object> m;
                    int i = this.index;
                    Mono<?>[] a = this.ignoreMonos;
                    if (i == a.length) {
                        this.ignore.clear();
                        m = this.lastMono;
                        if (m instanceof Callable) {
                            Object v;
                            try {
                                v = ((Callable)((Object)m)).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex));
                                return;
                            }
                            if (v == null) {
                                this.actual.onComplete();
                            } else {
                                this.complete(v);
                            }
                            return;
                        }
                        this.active = true;
                        m.subscribe(this.accept);
                    } else {
                        m = a[i];
                        this.index = i + 1;
                        if (m instanceof Callable) {
                            try {
                                ((Callable)((Object)m)).call();
                            }
                            catch (Throwable ex) {
                                this.actual.onError(Operators.onOperatorError(ex));
                                return;
                            }
                        }
                        this.active = true;
                        m.subscribe(this.ignore);
                    }
                }
                if (WIP.decrementAndGet(this) == 0) break;
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.ignore.cancel();
            this.accept.cancel();
        }

        void ignoreDone() {
            this.active = false;
            this.drain();
        }
    }
}

