/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoTakeLastOne<T>
extends MonoSource<T, T>
implements Fuseable {
    final T defaultValue;

    public MonoTakeLastOne(Publisher<? extends T> source) {
        super(source);
        this.defaultValue = null;
    }

    public MonoTakeLastOne(Publisher<? extends T> source, T defaultValue) {
        super(source);
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new TakeLastOneSubscriber<T>(s, this.defaultValue, true));
    }

    static final class TakeLastOneSubscriber<T>
    extends Operators.MonoSubscriber<T, T>
    implements Receiver {
        final boolean mustEmit;
        final T defaultValue;
        Subscription s;

        public TakeLastOneSubscriber(Subscriber<? super T> actual, T defaultValue, boolean mustEmit) {
            super(actual);
            this.defaultValue = defaultValue;
            this.mustEmit = mustEmit;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.value = t;
        }

        @Override
        public void onComplete() {
            Object v = this.value;
            if (v == null) {
                if (this.mustEmit) {
                    if (this.defaultValue != null) {
                        this.complete(this.defaultValue);
                    } else {
                        this.actual.onError(Operators.onOperatorError(new NoSuchElementException("Flux#last() didn't observe any onNext signal")));
                    }
                } else {
                    this.actual.onComplete();
                }
                return;
            }
            this.complete(v);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void setValue(T value) {
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

