/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoSupplier<T>
extends Mono<T>
implements Receiver,
Callable<T>,
Fuseable {
    final Supplier<? extends T> supplier;

    public MonoSupplier(Supplier<? extends T> callable) {
        this.supplier = Objects.requireNonNull(callable, "callable");
    }

    @Override
    public Object upstream() {
        return this.supplier;
    }

    public void subscribe(Subscriber<? super T> s) {
        T t;
        Operators.MonoSubscriber sds = new Operators.MonoSubscriber(s);
        s.onSubscribe(sds);
        if (sds.isCancelled()) {
            return;
        }
        try {
            t = this.supplier.get();
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        if (t == null) {
            s.onError(Operators.onOperatorError(new NullPointerException("The callable returned null")));
            return;
        }
        sds.complete(t);
    }

    @Override
    public T blockMillis(long m) {
        return this.supplier.get();
    }

    @Override
    public T block() {
        return this.supplier.get();
    }

    @Override
    public T call() throws Exception {
        return this.supplier.get();
    }
}

