/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.Mono;

public class MonoSource<I, O>
extends Mono<O>
implements Receiver {
    protected final Publisher<? extends I> source;

    public static <I> Mono<I> wrap(Publisher<? extends I> source) {
        if (source instanceof Fuseable) {
            return MonoSource.onAssembly(new FuseableMonoSource<I>(source));
        }
        return MonoSource.onAssembly(new MonoSource(source));
    }

    protected MonoSource(Publisher<? extends I> source) {
        this.source = Objects.requireNonNull(source);
    }

    public void subscribe(Subscriber<? super O> s) {
        this.source.subscribe(s);
    }

    @Override
    public String toString() {
        return "{ operator : \"" + this.getClass().getSimpleName().replaceAll("Mono", "") + "\" " + '}';
    }

    public final Publisher<? extends I> upstream() {
        return this.source;
    }

    static final class FuseableMonoSource<I>
    extends MonoSource<I, I>
    implements Fuseable {
        public FuseableMonoSource(Publisher<? extends I> source) {
            super(source);
        }
    }
}

