/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxRetryPredicate;
import reactor.core.publisher.MonoSource;

final class MonoRetryPredicate<T>
extends MonoSource<T, T> {
    final Predicate<Throwable> predicate;

    public MonoRetryPredicate(Publisher<? extends T> source, Predicate<Throwable> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxRetryPredicate.RetryPredicateSubscriber<T> parent = new FluxRetryPredicate.RetryPredicateSubscriber<T>(this.source, s, this.predicate);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }
}

