/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxRetry;
import reactor.core.publisher.MonoSource;

final class MonoRetry<T>
extends MonoSource<T, T> {
    final long times;

    public MonoRetry(Publisher<? extends T> source, long times) {
        super(source);
        if (times < 0L) {
            throw new IllegalArgumentException("times >= 0 required");
        }
        this.times = times;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxRetry.RetrySubscriber<T> parent = new FluxRetry.RetrySubscriber<T>(this.source, s, this.times);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }
}

