/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoReduceSeed<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final Supplier<R> initialSupplier;
    final BiFunction<R, ? super T, R> accumulator;

    public MonoReduceSeed(Publisher<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.initialSupplier = Objects.requireNonNull(initialSupplier, "initialSupplier");
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        R initialValue;
        try {
            initialValue = this.initialSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (initialValue == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The initial value supplied is null")));
            return;
        }
        this.source.subscribe(new ReduceSubscriber<T, R>(s, this.accumulator, initialValue));
    }

    static final class ReduceSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R>
    implements Receiver {
        final BiFunction<R, ? super T, R> accumulator;
        Subscription s;
        boolean done;

        public ReduceSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R value) {
            super(actual);
            this.accumulator = accumulator;
            this.value = value;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void setValue(R value) {
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            R v;
            try {
                v = this.accumulator.apply(this.value, t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this, e, t));
                return;
            }
            if (v == null) {
                this.onError(Operators.onOperatorError(this, new NullPointerException("The accumulator returned a null value"), t));
                return;
            }
            this.value = v;
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.complete(this.value);
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object connectedInput() {
            return this.accumulator;
        }
    }
}

