/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoHasElements<T>
extends MonoSource<T, Boolean>
implements Fuseable {
    public MonoHasElements(Publisher<? extends T> source) {
        super(source);
    }

    @Override
    public void subscribe(Subscriber<? super Boolean> s) {
        this.source.subscribe(new HasElementsSubscriber((Subscriber<? super Boolean>)((Subscriber<Boolean>)s)));
    }

    static final class HasElementsSubscriber<T>
    extends Operators.MonoSubscriber<T, Boolean>
    implements Receiver {
        Subscription s;

        public HasElementsSubscriber(Subscriber<? super Boolean> actual) {
            super(actual);
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            this.s.cancel();
            this.complete(true);
        }

        @Override
        public void onComplete() {
            this.complete(false);
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

