/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxHandleFuseable;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.SynchronousSink;

final class MonoHandleFuseable<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final BiConsumer<? super T, SynchronousSink<R>> handler;

    public MonoHandleFuseable(Publisher<? extends T> source, BiConsumer<? super T, SynchronousSink<R>> handler) {
        super(source);
        this.handler = Objects.requireNonNull(handler, "handler");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new FluxHandleFuseable.HandleFuseableConditionalSubscriber<T, R>(cs, this.handler));
            return;
        }
        this.source.subscribe(new FluxHandleFuseable.HandleFuseableSubscriber<T, R>(s, this.handler));
    }
}

