/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.MultiReceiver;
import reactor.core.publisher.FluxFirstEmitting;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoFirst<T>
extends Mono<T>
implements MultiReceiver {
    final Mono<? extends T>[] array;
    final Iterable<? extends Mono<? extends T>> iterable;

    @SafeVarargs
    public MonoFirst(Mono<? extends T> ... array) {
        this.array = Objects.requireNonNull(array, "array");
        this.iterable = null;
    }

    public MonoFirst(Iterable<? extends Mono<? extends T>> iterable) {
        this.array = null;
        this.iterable = Objects.requireNonNull(iterable);
    }

    public Mono<T> orAdditionalSource(Mono<? extends T> other) {
        int n = this.array.length;
        Mono[] newArray = new Mono[n + 1];
        System.arraycopy(this.array, 0, newArray, 0, n);
        newArray[n] = other;
        return new MonoFirst<T>(newArray);
    }

    @Override
    public Iterator<?> upstreams() {
        return this.iterable != null ? this.iterable.iterator() : Arrays.asList(this.array).iterator();
    }

    @Override
    public long upstreamCount() {
        return this.array != null ? (long)this.array.length : -1L;
    }

    public void subscribe(Subscriber<? super T> s) {
        int n;
        Mono<? extends T>[] a;
        block15: {
            a = this.array;
            if (a == null) {
                Iterator<Mono<T>> it;
                n = 0;
                a = new Publisher[8];
                try {
                    it = this.iterable.iterator();
                }
                catch (Throwable e) {
                    Operators.error(s, Operators.onOperatorError(e));
                    return;
                }
                if (it == null) {
                    Operators.error(s, new NullPointerException("The iterator returned is null"));
                    return;
                }
                while (true) {
                    Publisher p;
                    boolean b;
                    try {
                        b = it.hasNext();
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (!b) break block15;
                    try {
                        p = it.next();
                    }
                    catch (Throwable e) {
                        Operators.error(s, Operators.onOperatorError(e));
                        return;
                    }
                    if (p == null) {
                        Operators.error(s, new NullPointerException("The Publisher returned by the iterator is null"));
                        return;
                    }
                    if (n == a.length) {
                        Publisher[] c = new Publisher[n + (n >> 2)];
                        System.arraycopy(a, 0, c, 0, n);
                        a = c;
                    }
                    a[n++] = p;
                }
            }
            n = a.length;
        }
        if (n == 0) {
            Operators.complete(s);
            return;
        }
        if (n == 1) {
            Mono<? extends T> p = a[0];
            if (p == null) {
                Operators.error(s, new NullPointerException("The single source Publisher is null"));
            } else {
                p.subscribe(s);
            }
            return;
        }
        FluxFirstEmitting.RaceCoordinator<? super T> coordinator = new FluxFirstEmitting.RaceCoordinator<T>(n);
        coordinator.subscribe(a, n, s);
    }
}

