/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxFilter;
import reactor.core.publisher.FluxFilterFuseable;
import reactor.core.publisher.MonoSource;

final class MonoFilter<T>
extends MonoSource<T, T> {
    final Predicate<? super T> predicate;

    public MonoFilter(Publisher<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    public Predicate<? super T> predicate() {
        return this.predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.source instanceof Fuseable) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                this.source.subscribe(new FluxFilterFuseable.FilterFuseableConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)s, this.predicate));
                return;
            }
            this.source.subscribe(new FluxFilterFuseable.FilterFuseableSubscriber<T>(s, this.predicate));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FluxFilter.FilterConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)s, this.predicate));
            return;
        }
        this.source.subscribe(new FluxFilter.FilterSubscriber<T>(s, this.predicate));
    }
}

