/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.Trackable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

final class MonoError<T>
extends Mono<T>
implements Trackable {
    final Supplier<? extends Throwable> supplier;

    public MonoError(Throwable error) {
        this(MonoError.create(error));
    }

    static Supplier<Throwable> create(Throwable error) {
        Objects.requireNonNull(error);
        return () -> error;
    }

    public MonoError(Supplier<? extends Throwable> supplier) {
        this.supplier = Objects.requireNonNull(supplier);
    }

    @Override
    public Throwable getError() {
        return this.supplier.get();
    }

    @Override
    public T blockMillis(long m) {
        throw Exceptions.propagate(this.getError());
    }

    @Override
    public T block() {
        throw Exceptions.propagate(this.getError());
    }

    public void subscribe(Subscriber<? super T> s) {
        Throwable e;
        try {
            e = this.supplier.get();
        }
        catch (Throwable ex) {
            e = ex;
        }
        if (e == null) {
            e = new NullPointerException("The Throwable returned by the supplier is null");
        }
        Operators.error(s, Operators.onOperatorError(e));
    }

    @Override
    public boolean isTerminated() {
        return true;
    }
}

