/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.TimedScheduler;

final class MonoDelay
extends Mono<Long> {
    final TimedScheduler timedScheduler;
    final long delay;
    final TimeUnit unit;

    public MonoDelay(long delay, TimeUnit unit, TimedScheduler timedScheduler) {
        this.delay = delay;
        this.unit = Objects.requireNonNull(unit, "unit");
        this.timedScheduler = Objects.requireNonNull(timedScheduler, "timedScheduler");
    }

    public void subscribe(Subscriber<? super Long> s) {
        MonoDelayRunnable r = new MonoDelayRunnable(s);
        s.onSubscribe((Subscription)r);
        Cancellation f = this.timedScheduler.schedule(r, this.delay, this.unit);
        if (f == Scheduler.REJECTED) {
            if (r.cancel != MonoDelayRunnable.CANCELLED && r.cancel != MonoDelayRunnable.FINISHED) {
                s.onError((Throwable)Operators.onRejectedExecution(r, null, null));
            }
        } else {
            r.setCancel(f);
        }
    }

    static final class MonoDelayRunnable
    implements Runnable,
    Subscription {
        final Subscriber<? super Long> s;
        volatile Cancellation cancel;
        static final AtomicReferenceFieldUpdater<MonoDelayRunnable, Cancellation> CANCEL = AtomicReferenceFieldUpdater.newUpdater(MonoDelayRunnable.class, Cancellation.class, "cancel");
        volatile boolean requested;
        static final Cancellation CANCELLED = () -> {};
        static final Cancellation FINISHED = () -> {};

        public MonoDelayRunnable(Subscriber<? super Long> s) {
            this.s = s;
        }

        public void setCancel(Cancellation cancel) {
            if (!CANCEL.compareAndSet(this, null, cancel)) {
                cancel.dispose();
            }
        }

        @Override
        public void run() {
            if (this.requested) {
                try {
                    if (CANCEL.getAndSet(this, FINISHED) != CANCELLED) {
                        this.s.onNext((Object)0L);
                    }
                    if (this.cancel != CANCELLED) {
                        this.s.onComplete();
                    }
                }
                catch (Throwable t) {
                    this.s.onError(Operators.onOperatorError(t));
                }
            } else {
                this.s.onError((Throwable)Exceptions.failWithOverflow("Could not emit value due to lack of requests"));
            }
        }

        public void cancel() {
            Cancellation c = this.cancel;
            if (c != CANCELLED && c != FINISHED && (c = CANCEL.getAndSet(this, CANCELLED)) != null && c != CANCELLED && c != FINISHED) {
                c.dispose();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                this.requested = true;
            }
        }
    }
}

