/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.MonoSource;
import reactor.core.publisher.Operators;

final class MonoCollect<T, R>
extends MonoSource<T, R>
implements Fuseable {
    final Supplier<R> supplier;
    final BiConsumer<? super R, ? super T> action;

    public MonoCollect(Publisher<? extends T> source, Supplier<R> supplier, BiConsumer<? super R, ? super T> action) {
        super(source);
        this.supplier = Objects.requireNonNull(supplier, "supplier");
        this.action = Objects.requireNonNull(action);
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        R container;
        try {
            container = this.supplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (container == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The supplier returned a null container")));
            return;
        }
        this.source.subscribe(new CollectSubscriber<T, R>(s, this.action, container));
    }

    static final class CollectSubscriber<T, R>
    extends Operators.MonoSubscriber<T, R>
    implements Receiver {
        final BiConsumer<? super R, ? super T> action;
        Subscription s;
        boolean done;

        public CollectSubscriber(Subscriber<? super R> actual, BiConsumer<? super R, ? super T> action, R container) {
            super(actual);
            this.action = action;
            this.value = container;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.s.cancel();
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                this.action.accept(this.value, t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this, e, t));
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.complete(this.value);
        }

        @Override
        public void setValue(R value) {
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object connectedInput() {
            return this.action;
        }

        @Override
        public Object connectedOutput() {
            return this.value;
        }
    }
}

