/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.MonoSource;

final class MonoCallableOnAssembly<T>
extends MonoSource<T, T>
implements Fuseable,
Callable<T>,
AssemblyOp {
    final String stacktrace;

    public MonoCallableOnAssembly(Publisher<? extends T> source, boolean trace) {
        super(source);
        this.stacktrace = trace ? FluxOnAssembly.takeStacktrace(source) : null;
    }

    @Override
    public T block() {
        return this.blockMillis(-1L);
    }

    @Override
    public T blockMillis(long timeout) {
        try {
            return (T)((Callable)this.source).call();
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw Exceptions.bubble(e);
        }
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxOnAssembly.subscribe(s, this.source, this.stacktrace, this);
    }

    @Override
    public T call() throws Exception {
        return (T)((Callable)this.source).call();
    }
}

