/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.ConnectableFlux;
import reactor.core.publisher.ConnectableFluxOnAssembly;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxCallableOnAssembly;
import reactor.core.publisher.FluxOnAssembly;
import reactor.core.publisher.FluxPeek;
import reactor.core.publisher.FluxPeekFuseable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoCallableOnAssembly;
import reactor.core.publisher.MonoOnAssembly;
import reactor.core.publisher.MonoPeek;
import reactor.core.publisher.MonoPeekFuseable;
import reactor.core.publisher.ParallelFlux;
import reactor.core.publisher.ParallelFluxOnAssembly;
import reactor.core.publisher.ParallelUnorderedPeek;
import reactor.core.publisher.SignalLogger;
import reactor.core.publisher.SignalType;
import reactor.util.Logger;
import reactor.util.Loggers;

public abstract class Hooks {
    static volatile OnOperatorCreate<?> onOperatorCreate;
    static volatile Consumer<? super Throwable> onErrorDroppedHook;
    static volatile Consumer<Object> onNextDroppedHook;
    static volatile BiFunction<? super Throwable, Object, ? extends Throwable> onOperatorErrorHook;
    static final Logger log;

    public static void onErrorDropped(Consumer<? super Throwable> c) {
        log.info("Hooking new default : onErrorDropped");
        onErrorDroppedHook = Objects.requireNonNull(c, "onErrorDroppedHook");
    }

    public static void onNextDropped(Consumer<Object> c) {
        log.info("Hooking new default : onNextDropped");
        onNextDroppedHook = Objects.requireNonNull(c, "onNextDroppedHook");
    }

    public static <T> void onOperator(Function<? super OperatorHook<T>, ? extends OperatorHook<T>> newHook) {
        log.info("Hooking new default : onOperator");
        onOperatorCreate = new OnOperatorCreate(newHook);
    }

    public static void onOperatorError(BiFunction<? super Throwable, Object, ? extends Throwable> f) {
        log.info("Hooking new default : onOperatorError");
        onOperatorErrorHook = Objects.requireNonNull(f, "onOperatorErrorHook");
    }

    public static void resetOnErrorDropped() {
        log.info("Reset to factory defaults : onErrorDropped");
        onErrorDroppedHook = null;
    }

    public static void resetOnNextDropped() {
        log.info("Reset to factory defaults : onNextDropped");
        onNextDroppedHook = null;
    }

    public static void resetOnOperator() {
        log.info("Reset to factory defaults : onOperator");
        onOperatorCreate = null;
    }

    public static void resetOnOperatorError() {
        log.info("Reset to factory defaults : onOperatorError");
        onOperatorErrorHook = null;
    }

    Hooks() {
    }

    static {
        boolean globalTrace = Boolean.parseBoolean(System.getProperty("reactor.trace.operatorStacktrace", "false"));
        if (globalTrace) {
            onOperatorCreate = new OnOperatorCreate(OperatorHook::operatorStacktrace);
        }
        log = Loggers.getLogger(Hooks.class);
    }

    static final class OnOperatorCreate<T>
    implements Function<Publisher<T>, Publisher<T>> {
        final Function<? super OperatorHook<T>, ? extends OperatorHook<T>> hook;

        OnOperatorCreate(Function<? super OperatorHook<T>, ? extends OperatorHook<T>> hook) {
            this.hook = hook;
        }

        @Override
        public Publisher<T> apply(Publisher<T> publisher) {
            if (this.hook != null && !(publisher instanceof ConnectableFlux)) {
                OperatorHook<T> hooks = Objects.requireNonNull(this.hook.apply(new OperatorHook<T>(publisher)), "hook");
                if (hooks.tracedLevel != null) {
                    SignalLogger<T> peek = new SignalLogger<T>(publisher, hooks.tracedCategory, hooks.tracedLevel, true, hooks.tracedSignals);
                    hooks = hooks.doOnSignal(peek.onSubscribeCall(), peek.onNextCall(), peek.onErrorCall(), peek.onCompleteCall(), peek.onAfterTerminateCall(), peek.onRequestCall(), peek.onCancelCall());
                }
                if (hooks != OperatorHook.IGNORE) {
                    publisher = hooks.publisher;
                    boolean trace = hooks.traced;
                    if (trace) {
                        if (publisher instanceof Callable) {
                            if (publisher instanceof Mono) {
                                return new MonoCallableOnAssembly<T>(publisher, true);
                            }
                            return new FluxCallableOnAssembly<T>(publisher, true);
                        }
                        if (publisher instanceof Mono) {
                            return new MonoOnAssembly<T>(publisher, true);
                        }
                        if (publisher instanceof ConnectableFlux) {
                            return new ConnectableFluxOnAssembly((ConnectableFlux)publisher, true);
                        }
                        if (publisher instanceof ParallelFlux) {
                            return new ParallelFluxOnAssembly((ParallelFlux)publisher, true);
                        }
                        return new FluxOnAssembly<T>(publisher, true);
                    }
                    return publisher;
                }
            }
            return publisher;
        }
    }

    public static final class OperatorHook<T> {
        static final OperatorHook IGNORE = new OperatorHook(null);
        final Publisher<T> publisher;
        String tracedCategory;
        Level tracedLevel;
        SignalType[] tracedSignals;
        boolean traced;

        public final OperatorHook<T> doOnEach(Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall) {
            return this.doOnSignal(null, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, null, null);
        }

        public final OperatorHook<T> doOnLifecycle(Consumer<? super Subscription> onSubscribeCall, LongConsumer onRequestCall, Runnable onCancelCall) {
            return this.doOnSignal(onSubscribeCall, null, null, null, null, onRequestCall, onCancelCall);
        }

        final OperatorHook<T> doOnSignal(Consumer<? super Subscription> onSubscribeCall, Consumer<? super T> onNextCall, Consumer<? super Throwable> onErrorCall, Runnable onCompleteCall, Runnable onAfterTerminateCall, LongConsumer onRequestCall, Runnable onCancelCall) {
            if (this == IGNORE || this.publisher instanceof ConnectableFlux) {
                return this;
            }
            if (this.publisher instanceof Mono) {
                if (this.publisher instanceof Fuseable) {
                    return new OperatorHook<T>(new MonoPeekFuseable<T>(this.publisher, onSubscribeCall, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, onRequestCall, onCancelCall), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
                }
                return new OperatorHook<T>(new MonoPeek<T>(this.publisher, onSubscribeCall, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, onRequestCall, onCancelCall), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            if (this.publisher instanceof ParallelFlux) {
                ParallelUnorderedPeek<? super T> _p = new ParallelUnorderedPeek<T>((ParallelFlux)this.publisher, onNextCall, null, onErrorCall, onCompleteCall, onAfterTerminateCall, onSubscribeCall, onRequestCall, onCancelCall);
                return new OperatorHook<T>(_p, this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            if (this.publisher instanceof Fuseable) {
                return new OperatorHook<T>(new FluxPeekFuseable<T>(this.publisher, onSubscribeCall, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, onRequestCall, onCancelCall), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
            }
            return new OperatorHook<T>(new FluxPeek<T>(this.publisher, onSubscribeCall, onNextCall, onErrorCall, onCompleteCall, onAfterTerminateCall, onRequestCall, onCancelCall), this.traced, this.tracedCategory, this.tracedLevel, this.tracedSignals);
        }

        public final OperatorHook<T> ignore() {
            return IGNORE;
        }

        public final OperatorHook<T> ifFlux() {
            return this.publisher() instanceof Flux ? this : IGNORE;
        }

        public final OperatorHook<T> ifMono() {
            return this.publisher() instanceof Mono ? this : IGNORE;
        }

        public final OperatorHook<T> ifParallelFlux() {
            return this.publisher() instanceof ParallelFlux ? this : IGNORE;
        }

        public final OperatorHook<T> ifName(String ... names) {
            if (this == IGNORE) {
                return this;
            }
            String className = this.publisher().getClass().getSimpleName().replaceAll("Flux|Mono|Parallel|Fuseable", "");
            for (String name : names) {
                if (!className.equalsIgnoreCase(name)) continue;
                return this;
            }
            return IGNORE;
        }

        public final OperatorHook<T> ifNameContains(String ... names) {
            if (this == IGNORE) {
                return this;
            }
            String className = this.publisher().getClass().getSimpleName().replaceAll("Flux|Mono|Parallel|Fuseable", "").toLowerCase();
            for (String name : names) {
                if (!className.contains(name.toLowerCase())) continue;
                return this;
            }
            return IGNORE;
        }

        public OperatorHook<T> log(String category, SignalType ... options) {
            return this.log(category, Level.INFO, options);
        }

        public OperatorHook<T> log(String category, boolean showOperatorLine, SignalType ... options) {
            return this.log(category, Level.INFO, showOperatorLine, options);
        }

        public OperatorHook<T> log(String category, Level level, SignalType ... options) {
            Objects.requireNonNull(level, "level");
            SignalLogger<T> peek = new SignalLogger<T>(this.publisher, category, level, false, options);
            return this.doOnSignal(peek.onSubscribeCall(), peek.onNextCall(), peek.onErrorCall(), peek.onCompleteCall(), peek.onAfterTerminateCall(), peek.onRequestCall(), peek.onCancelCall());
        }

        public OperatorHook<T> log(String category, Level level, boolean showOperatorLine, SignalType ... options) {
            if (this == IGNORE) {
                return this;
            }
            Objects.requireNonNull(level, "level");
            if (showOperatorLine) {
                this.tracedCategory = category;
                this.tracedLevel = level;
                this.tracedSignals = options;
                return this;
            }
            return this.log(category, level, options);
        }

        public OperatorHook<T> operatorStacktrace() {
            if (this == IGNORE) {
                return this;
            }
            this.traced = true;
            return this;
        }

        public Publisher<T> publisher() {
            return this.publisher;
        }

        OperatorHook(Publisher<T> p) {
            this(p, false, null, null, null);
        }

        OperatorHook(Publisher<T> p, boolean traced, String tracedCategory, Level tracedLevel, SignalType[] tracedSignals) {
            this.traced = traced;
            this.publisher = p;
            this.tracedSignals = tracedSignals;
            this.tracedLevel = tracedLevel;
            this.tracedCategory = tracedCategory;
        }
    }
}

