/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxZipIterable<T, U, R>
extends FluxSource<T, R> {
    final Iterable<? extends U> other;
    final BiFunction<? super T, ? super U, ? extends R> zipper;

    public FluxZipIterable(Publisher<? extends T> source, Iterable<? extends U> other, BiFunction<? super T, ? super U, ? extends R> zipper) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.zipper = Objects.requireNonNull(zipper, "zipper");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        boolean b;
        Iterator<U> it;
        try {
            it = this.other.iterator();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (it == null) {
            Operators.error(s, new NullPointerException("The other iterable produced a null iterator"));
            return;
        }
        try {
            b = it.hasNext();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (!b) {
            Operators.complete(s);
            return;
        }
        this.source.subscribe(new ZipSubscriber<T, U, R>(s, it, this.zipper));
    }

    static final class ZipSubscriber<T, U, R>
    implements Subscriber<T>,
    Producer,
    MultiReceiver,
    Receiver,
    Subscription,
    Trackable {
        final Subscriber<? super R> actual;
        final Iterator<? extends U> it;
        final BiFunction<? super T, ? super U, ? extends R> zipper;
        Subscription s;
        boolean done;

        public ZipSubscriber(Subscriber<? super R> actual, Iterator<? extends U> it, BiFunction<? super T, ? super U, ? extends R> zipper) {
            this.actual = actual;
            this.it = it;
            this.zipper = zipper;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            boolean b;
            R r;
            U u;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                u = this.it.next();
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            try {
                r = this.zipper.apply(t, u);
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (r == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The zipper returned a null value"), t));
                return;
            }
            this.actual.onNext(r);
            try {
                b = this.it.hasNext();
            }
            catch (Throwable e) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (!b) {
                this.done = true;
                this.s.cancel();
                this.actual.onComplete();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Iterator<?> upstreams() {
            return this.isStarted() ? Arrays.asList(this.s, this.it).iterator() : null;
        }

        @Override
        public long upstreamCount() {
            return this.isStarted() ? 2L : 1L;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

