/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Disposable;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

final class FluxWindowBoundary<T, U>
extends FluxSource<T, Flux<T>> {
    final Publisher<U> other;
    final Supplier<? extends Queue<T>> processorQueueSupplier;
    final Supplier<? extends Queue<Object>> drainQueueSupplier;

    public FluxWindowBoundary(Publisher<? extends T> source, Publisher<U> other, Supplier<? extends Queue<T>> processorQueueSupplier, Supplier<? extends Queue<Object>> drainQueueSupplier) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
        this.processorQueueSupplier = Objects.requireNonNull(processorQueueSupplier, "processorQueueSupplier");
        this.drainQueueSupplier = Objects.requireNonNull(drainQueueSupplier, "drainQueueSupplier");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super Flux<T>> s) {
        Queue<Object> dq;
        Queue<T> q;
        try {
            q = this.processorQueueSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (q == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The processorQueueSupplier returned a null queue")));
            return;
        }
        try {
            dq = this.drainQueueSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (dq == null) {
            Operators.error(s, Operators.onOperatorError(new NullPointerException("The drainQueueSupplier returned a null queue")));
            return;
        }
        WindowBoundaryMain main = new WindowBoundaryMain(s, this.processorQueueSupplier, q, dq);
        s.onSubscribe(main);
        if (main.emit(main.window)) {
            this.other.subscribe(main.boundary);
            this.source.subscribe(main);
        }
    }

    static final class WindowBoundaryOther<U>
    extends Operators.DeferredSubscription
    implements Subscriber<U> {
        final WindowBoundaryMain<?, U> main;

        public WindowBoundaryOther(WindowBoundaryMain<?, U> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            if (this.set(s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        public void onNext(U t) {
            this.main.boundaryNext();
        }

        public void onError(Throwable t) {
            this.main.boundaryError(t);
        }

        public void onComplete() {
            this.main.boundaryComplete();
        }
    }

    static final class WindowBoundaryMain<T, U>
    implements Subscriber<T>,
    Subscription,
    Disposable {
        final Subscriber<? super Flux<T>> actual;
        final Supplier<? extends Queue<T>> processorQueueSupplier;
        final WindowBoundaryOther<U> boundary;
        final Queue<Object> queue;
        UnicastProcessor<T> window;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<WindowBoundaryMain, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(WindowBoundaryMain.class, Subscription.class, "s");
        volatile long requested;
        static final AtomicLongFieldUpdater<WindowBoundaryMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(WindowBoundaryMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> WIP = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "wip");
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<WindowBoundaryMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(WindowBoundaryMain.class, Throwable.class, "error");
        volatile int open;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> OPEN = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "open");
        volatile int once;
        static final AtomicIntegerFieldUpdater<WindowBoundaryMain> ONCE = AtomicIntegerFieldUpdater.newUpdater(WindowBoundaryMain.class, "once");
        static final Object BOUNDARY_MARKER = new Object();
        static final Object DONE = new Object();

        public WindowBoundaryMain(Subscriber<? super Flux<T>> actual, Supplier<? extends Queue<T>> processorQueueSupplier, Queue<T> processorQueue, Queue<Object> queue) {
            this.actual = actual;
            this.processorQueueSupplier = processorQueueSupplier;
            this.window = new UnicastProcessor<T>(processorQueue, this);
            this.open = 2;
            this.boundary = new WindowBoundaryOther(this);
            this.queue = queue;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(t);
            }
            this.drain();
        }

        public void onError(Throwable t) {
            this.boundary.cancel();
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete() {
            this.boundary.cancel();
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(DONE);
            }
            this.drain();
        }

        @Override
        public void dispose() {
            if (OPEN.decrementAndGet(this) == 0) {
                this.cancelMain();
                this.boundary.cancel();
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        void cancelMain() {
            Operators.terminate(S, this);
        }

        public void cancel() {
            if (ONCE.compareAndSet(this, 0, 1)) {
                this.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void boundaryNext() {
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(BOUNDARY_MARKER);
            }
            if (this.once != 0) {
                this.boundary.cancel();
            }
            this.drain();
        }

        void boundaryError(Throwable e) {
            this.cancelMain();
            if (Exceptions.addThrowable(ERROR, this, e)) {
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void boundaryComplete() {
            this.cancelMain();
            WindowBoundaryMain windowBoundaryMain = this;
            synchronized (windowBoundaryMain) {
                this.queue.offer(DONE);
            }
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            Subscriber<? super Flux<T>> a = this.actual;
            Queue<Object> q = this.queue;
            UnicastProcessor<Object> w = this.window;
            int missed = 1;
            while (true) {
                if (this.error != null) {
                    q.clear();
                    Throwable e = Exceptions.terminate(ERROR, this);
                    if (e != Exceptions.TERMINATED) {
                        w.onError(e);
                        a.onError(e);
                    }
                    return;
                }
                Object o = q.poll();
                if (o != null) {
                    if (o == DONE) {
                        q.clear();
                        w.onComplete();
                        a.onComplete();
                        return;
                    }
                    if (o != BOUNDARY_MARKER) {
                        Object v = o;
                        w.onNext(v);
                    }
                    if (o != BOUNDARY_MARKER) continue;
                    w.onComplete();
                    if (this.once != 0) continue;
                    if (this.requested != 0L) {
                        Queue<T> pq;
                        try {
                            pq = this.processorQueueSupplier.get();
                        }
                        catch (Throwable e) {
                            q.clear();
                            this.cancelMain();
                            this.boundary.cancel();
                            a.onError(e);
                            return;
                        }
                        if (pq == null) {
                            q.clear();
                            this.cancelMain();
                            this.boundary.cancel();
                            a.onError((Throwable)new NullPointerException("The processorQueueSupplier returned a null queue"));
                            return;
                        }
                        OPEN.getAndIncrement(this);
                        w = new UnicastProcessor<T>(pq, this);
                        this.window = w;
                        a.onNext(w);
                        if (this.requested == Long.MAX_VALUE) continue;
                        REQUESTED.decrementAndGet(this);
                        continue;
                    }
                    q.clear();
                    this.cancelMain();
                    this.boundary.cancel();
                    a.onError((Throwable)Exceptions.failWithOverflow("Could not create new window due to lack of requests"));
                    return;
                }
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        boolean emit(UnicastProcessor<T> w) {
            long r = this.requested;
            if (r != 0L) {
                this.actual.onNext(w);
                if (r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return true;
            }
            this.cancel();
            this.actual.onError((Throwable)Exceptions.failWithOverflow("Could not emit buffer due to lack of requests"));
            return false;
        }
    }
}

