/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxTakeUntilOther<T, U>
extends FluxSource<T, T> {
    final Publisher<U> other;

    public FluxTakeUntilOther(Publisher<? extends T> source, Publisher<U> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        TakeUntilMainSubscriber<? super T> mainSubscriber = new TakeUntilMainSubscriber<T>(s);
        TakeUntilOtherSubscriber otherSubscriber = new TakeUntilOtherSubscriber(mainSubscriber);
        this.other.subscribe(otherSubscriber);
        this.source.subscribe(mainSubscriber);
    }

    static final class TakeUntilMainSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<T> actual;
        volatile Subscription main;
        static final AtomicReferenceFieldUpdater<TakeUntilMainSubscriber, Subscription> MAIN = AtomicReferenceFieldUpdater.newUpdater(TakeUntilMainSubscriber.class, Subscription.class, "main");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<TakeUntilMainSubscriber, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(TakeUntilMainSubscriber.class, Subscription.class, "other");

        public TakeUntilMainSubscriber(Subscriber<? super T> actual) {
            this.actual = Operators.serialize(actual);
        }

        void setOther(Subscription s) {
            if (!OTHER.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.other != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            }
        }

        public void request(long n) {
            this.main.request(n);
        }

        void cancelMain() {
            Subscription s = this.main;
            if (s != Operators.cancelledSubscription() && (s = MAIN.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        void cancelOther() {
            Subscription s = this.other;
            if (s != Operators.cancelledSubscription() && (s = OTHER.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        public void cancel() {
            this.cancelMain();
            this.cancelOther();
        }

        public void onSubscribe(Subscription s) {
            if (!MAIN.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.main != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            } else {
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            this.actual.onNext(t);
        }

        public void onError(Throwable t) {
            if (this.main == null && MAIN.compareAndSet(this, null, Operators.cancelledSubscription())) {
                Operators.error(this.actual, t);
                return;
            }
            this.cancel();
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.main == null && MAIN.compareAndSet(this, null, Operators.cancelledSubscription())) {
                this.cancelOther();
                Operators.complete(this.actual);
                return;
            }
            this.cancel();
            this.actual.onComplete();
        }
    }

    static final class TakeUntilOtherSubscriber<U>
    implements Subscriber<U> {
        final TakeUntilMainSubscriber<?> main;
        boolean once;

        public TakeUntilOtherSubscriber(TakeUntilMainSubscriber<?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOther(s);
            s.request(Long.MAX_VALUE);
        }

        public void onNext(U t) {
            this.onComplete();
        }

        public void onError(Throwable t) {
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onError(t);
        }

        public void onComplete() {
            if (this.once) {
                return;
            }
            this.once = true;
            this.main.onComplete();
        }
    }
}

