/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.FluxTake;

final class FluxTakeFuseable<T>
extends FluxSource<T, T>
implements Fuseable {
    final long n;

    public FluxTakeFuseable(Publisher<? extends T> source, long n) {
        super(source);
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.n = n;
    }

    public Publisher<? extends T> source() {
        return this.source;
    }

    public long n() {
        return this.n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        this.source.subscribe(new FluxTake.TakeFuseableSubscriber<T>(s, this.n));
    }
}

