/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Loopback;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSwitchIfEmpty<T>
extends FluxSource<T, T> {
    final Publisher<? extends T> other;

    public FluxSwitchIfEmpty(Publisher<? extends T> source, Publisher<? extends T> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        SwitchIfEmptySubscriber<? extends T> parent = new SwitchIfEmptySubscriber<T>(s, this.other);
        s.onSubscribe(parent);
        this.source.subscribe(parent);
    }

    static final class SwitchIfEmptySubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T>
    implements Loopback {
        final Publisher<? extends T> other;
        boolean once;

        public SwitchIfEmptySubscriber(Subscriber<? super T> actual, Publisher<? extends T> other) {
            super(actual);
            this.other = other;
        }

        public void onNext(T t) {
            if (!this.once) {
                this.once = true;
            }
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            if (!this.once) {
                this.once = true;
                this.other.subscribe((Subscriber)this);
            } else {
                this.subscriber.onComplete();
            }
        }

        @Override
        public Object connectedInput() {
            return null;
        }

        @Override
        public Object connectedOutput() {
            return this.other;
        }
    }
}

