/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Cancellation;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.scheduler.Scheduler;

final class FluxSubscribeOnValue<T>
extends Flux<T>
implements Fuseable {
    final T value;
    final Scheduler scheduler;

    public FluxSubscribeOnValue(T value, Scheduler scheduler) {
        this.value = value;
        this.scheduler = Objects.requireNonNull(scheduler, "scheduler");
    }

    public void subscribe(Subscriber<? super T> s) {
        T v = this.value;
        if (v == null) {
            ScheduledEmpty parent = new ScheduledEmpty(s);
            s.onSubscribe((Subscription)parent);
            Cancellation f = this.scheduler.schedule(parent);
            if (f == Scheduler.REJECTED) {
                if (parent.future != ScheduledEmpty.CANCELLED) {
                    s.onError((Throwable)Operators.onRejectedExecution());
                }
            } else {
                parent.setFuture(f);
            }
        } else {
            s.onSubscribe(new ScheduledScalar<T>(s, v, this.scheduler));
        }
    }

    public static <T> boolean scalarScheduleOn(Publisher<? extends T> source, Subscriber<? super T> s, Scheduler scheduler) {
        if (source instanceof Fuseable.ScalarCallable) {
            Fuseable.ScalarCallable supplier = (Fuseable.ScalarCallable)source;
            Object v = supplier.call();
            if (v == null) {
                ScheduledEmpty parent = new ScheduledEmpty(s);
                s.onSubscribe((Subscription)parent);
                Cancellation f = scheduler.schedule(parent);
                if (f == Scheduler.REJECTED) {
                    if (parent.future != ScheduledEmpty.CANCELLED) {
                        s.onError((Throwable)Operators.onRejectedExecution());
                    }
                } else {
                    parent.setFuture(f);
                }
            } else {
                s.onSubscribe(new ScheduledScalar<T>(s, v, scheduler));
            }
            return true;
        }
        return false;
    }

    static final class ScheduledEmpty
    implements Fuseable.QueueSubscription<Void>,
    Runnable,
    Producer,
    Loopback {
        final Subscriber<?> actual;
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<ScheduledEmpty, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ScheduledEmpty.class, Cancellation.class, "future");
        static final Cancellation CANCELLED = () -> {};
        static final Cancellation FINISHED = () -> {};

        public ScheduledEmpty(Subscriber<?> actual) {
            this.actual = actual;
        }

        public void request(long n) {
            Operators.validate(n);
        }

        public void cancel() {
            Cancellation f = this.future;
            if (f != CANCELLED && f != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                f.dispose();
            }
        }

        @Override
        public void run() {
            try {
                this.actual.onComplete();
            }
            finally {
                FUTURE.lazySet(this, FINISHED);
            }
        }

        void setFuture(Cancellation f) {
            Cancellation a;
            if (!FUTURE.compareAndSet(this, null, f) && (a = this.future) != FINISHED && a != CANCELLED) {
                f.dispose();
            }
        }

        @Override
        public Object connectedInput() {
            return null;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                return 2;
            }
            return 2;
        }

        @Override
        public Void poll() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public void clear() {
        }
    }

    static final class ScheduledScalar<T>
    implements Fuseable.QueueSubscription<T>,
    Runnable,
    Producer,
    Loopback {
        final Subscriber<? super T> actual;
        final T value;
        final Scheduler scheduler;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ScheduledScalar> ONCE = AtomicIntegerFieldUpdater.newUpdater(ScheduledScalar.class, "once");
        volatile Cancellation future;
        static final AtomicReferenceFieldUpdater<ScheduledScalar, Cancellation> FUTURE = AtomicReferenceFieldUpdater.newUpdater(ScheduledScalar.class, Cancellation.class, "future");
        static final Cancellation CANCELLED = () -> {};
        static final Cancellation FINISHED = () -> {};
        int fusionState;
        static final int NOT_FUSED = 0;
        static final int NO_VALUE = 1;
        static final int HAS_VALUE = 2;
        static final int COMPLETE = 3;

        public ScheduledScalar(Subscriber<? super T> actual, T value, Scheduler scheduler) {
            this.actual = actual;
            this.value = value;
            this.scheduler = scheduler;
        }

        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                Cancellation f = this.scheduler.schedule(this);
                if (f == Scheduler.REJECTED && this.future != FINISHED && this.future != CANCELLED) {
                    this.actual.onError((Throwable)Operators.onRejectedExecution(this, null, null));
                } else if (!FUTURE.compareAndSet(this, null, f) && this.future != FINISHED && this.future != CANCELLED) {
                    f.dispose();
                }
            }
        }

        public void cancel() {
            ONCE.lazySet(this, 1);
            Cancellation f = this.future;
            if (f != CANCELLED && this.future != FINISHED && (f = FUTURE.getAndSet(this, CANCELLED)) != null && f != CANCELLED && f != FINISHED) {
                f.dispose();
            }
        }

        @Override
        public void run() {
            try {
                if (this.fusionState == 1) {
                    this.fusionState = 2;
                }
                this.actual.onNext(this.value);
                this.actual.onComplete();
            }
            finally {
                FUTURE.lazySet(this, FINISHED);
            }
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.scheduler;
        }

        @Override
        public Object connectedOutput() {
            return this.value;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.fusionState = 1;
                return 2;
            }
            return 2;
        }

        @Override
        public T poll() {
            if (this.fusionState == 2) {
                this.fusionState = 3;
                return this.value;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.fusionState != 2;
        }

        @Override
        public int size() {
            return this.isEmpty() ? 0 : 1;
        }

        @Override
        public void clear() {
            this.fusionState = 3;
        }
    }
}

