/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSkipUntilOther<T, U>
extends FluxSource<T, T> {
    final Publisher<U> other;

    public FluxSkipUntilOther(Publisher<? extends T> source, Publisher<U> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        SkipUntilMainSubscriber<? super T> mainSubscriber = new SkipUntilMainSubscriber<T>(s);
        SkipUntilOtherSubscriber otherSubscriber = new SkipUntilOtherSubscriber(mainSubscriber);
        this.other.subscribe(otherSubscriber);
        this.source.subscribe(mainSubscriber);
    }

    static final class SkipUntilMainSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<T> actual;
        volatile Subscription main;
        static final AtomicReferenceFieldUpdater<SkipUntilMainSubscriber, Subscription> MAIN = AtomicReferenceFieldUpdater.newUpdater(SkipUntilMainSubscriber.class, Subscription.class, "main");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<SkipUntilMainSubscriber, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(SkipUntilMainSubscriber.class, Subscription.class, "other");
        volatile boolean gate;

        public SkipUntilMainSubscriber(Subscriber<? super T> actual) {
            this.actual = Operators.serialize(actual);
        }

        void setOther(Subscription s) {
            if (!OTHER.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.other != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            }
        }

        public void request(long n) {
            this.main.request(n);
        }

        void cancelMain() {
            Subscription s = this.main;
            if (s != Operators.cancelledSubscription() && (s = MAIN.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        void cancelOther() {
            Subscription s = this.other;
            if (s != Operators.cancelledSubscription() && (s = OTHER.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        public void cancel() {
            this.cancelMain();
            this.cancelOther();
        }

        public void onSubscribe(Subscription s) {
            if (!MAIN.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.main != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
            } else {
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.gate) {
                this.actual.onNext(t);
            } else {
                this.main.request(1L);
            }
        }

        public void onError(Throwable t) {
            if (this.main == null && MAIN.compareAndSet(this, null, Operators.cancelledSubscription())) {
                Operators.error(this.actual, t);
                return;
            }
            this.cancel();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.cancelOther();
            this.actual.onComplete();
        }
    }

    static final class SkipUntilOtherSubscriber<U>
    implements Subscriber<U> {
        final SkipUntilMainSubscriber<?> main;

        public SkipUntilOtherSubscriber(SkipUntilMainSubscriber<?> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOther(s);
            s.request(Long.MAX_VALUE);
        }

        public void onNext(U t) {
            if (this.main.gate) {
                return;
            }
            SkipUntilMainSubscriber<?> m = this.main;
            m.other.cancel();
            m.gate = true;
            m.other = Operators.cancelledSubscription();
        }

        public void onError(Throwable t) {
            SkipUntilMainSubscriber<?> m = this.main;
            if (m.gate) {
                return;
            }
            m.onError(t);
        }

        public void onComplete() {
            SkipUntilMainSubscriber<?> m = this.main;
            if (m.gate) {
                return;
            }
            m.gate = true;
            m.other = Operators.cancelledSubscription();
        }
    }
}

