/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSkip<T>
extends FluxSource<T, T> {
    final Publisher<? extends T> source;
    final long n;

    public FluxSkip(Publisher<? extends T> source, long n) {
        super(source);
        if (n < 0L) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.source = Objects.requireNonNull(source, "source");
        this.n = n;
    }

    public long n() {
        return this.n;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (this.n == 0L) {
            this.source.subscribe(s);
        } else {
            this.source.subscribe(new SkipSubscriber<T>(s, this.n));
        }
    }

    static final class SkipSubscriber<T>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Subscription,
    Trackable {
        final Subscriber<? super T> actual;
        final long n;
        long remaining;
        Subscription s;

        public SkipSubscriber(Subscriber<? super T> actual, long n) {
            this.actual = actual;
            this.n = n;
            this.remaining = n;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(this.n);
            }
        }

        public void onNext(T t) {
            long r = this.remaining;
            if (r == 0L) {
                this.actual.onNext(t);
            } else {
                this.remaining = r - 1L;
            }
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
        }

        public void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.remaining != this.n;
        }

        @Override
        public boolean isTerminated() {
            return this.remaining == 0L;
        }

        @Override
        public long getCapacity() {
            return this.n;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public long expectedFromUpstream() {
            return this.remaining;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long limit() {
            return 0L;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

