/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxScanSeed<T, R>
extends FluxSource<T, R> {
    final BiFunction<R, ? super T, R> accumulator;
    final Supplier<R> initialSupplier;

    public FluxScanSeed(Publisher<? extends T> source, Supplier<R> initialSupplier, BiFunction<R, ? super T, R> accumulator) {
        super(source);
        this.accumulator = Objects.requireNonNull(accumulator, "accumulator");
        this.initialSupplier = Objects.requireNonNull(initialSupplier, "initialSupplier");
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        R initialValue;
        try {
            initialValue = this.initialSupplier.get();
        }
        catch (Throwable e) {
            Operators.error(s, Operators.onOperatorError(e));
            return;
        }
        if (initialValue == null) {
            Operators.error(s, new NullPointerException("The initial value supplied is null"));
            return;
        }
        this.source.subscribe(new ScanSubscriber<T, R>(s, this.accumulator, initialValue));
    }

    static final class ScanSubscriber<T, R>
    implements Subscriber<T>,
    Subscription,
    Producer,
    Receiver,
    Loopback,
    Trackable {
        final Subscriber<? super R> actual;
        final BiFunction<R, ? super T, R> accumulator;
        Subscription s;
        R value;
        boolean done;
        static final long COMPLETED_MASK = Long.MIN_VALUE;
        static final long REQUESTED_MASK = Long.MAX_VALUE;
        volatile long requested;
        static final AtomicLongFieldUpdater<ScanSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(ScanSubscriber.class, "requested");
        long produced;

        public ScanSubscriber(Subscriber<? super R> actual, BiFunction<R, ? super T, R> accumulator, R initialValue) {
            this.actual = actual;
            this.accumulator = accumulator;
            this.value = initialValue;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            R r = this.value;
            ++this.produced;
            this.actual.onNext(r);
            try {
                r = this.accumulator.apply(r, t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (r == null) {
                this.s.cancel();
                this.onError(new NullPointerException("The accumulator returned a null value"));
                return;
            }
            this.value = r;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            R v = this.value;
            long p = this.produced;
            long r = this.requested;
            if (r != Long.MAX_VALUE && p != 0L) {
                r = REQUESTED.addAndGet(this, -p);
            }
            while (true) {
                if ((r & Long.MAX_VALUE) != 0L) {
                    this.actual.onNext(v);
                    this.actual.onComplete();
                    return;
                }
                if (REQUESTED.compareAndSet(this, 0L, Long.MIN_VALUE)) {
                    return;
                }
                r = this.requested;
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                long u;
                long r;
                do {
                    if ((r = this.requested) == Long.MIN_VALUE) {
                        if (REQUESTED.compareAndSet(this, Long.MIN_VALUE, -9223372036854775807L)) {
                            this.actual.onNext(this.value);
                            this.actual.onComplete();
                        }
                        return;
                    }
                    if (r >= 0L) continue;
                    return;
                } while (!REQUESTED.compareAndSet(this, r, u = Operators.addCap(r, n)));
                this.s.request(n);
                return;
            }
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested - this.produced;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.accumulator;
        }

        @Override
        public Object upstream() {
            return this.s;
        }
    }
}

