/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxSample<T, U>
extends FluxSource<T, T> {
    final Publisher<U> other;

    public FluxSample(Publisher<? extends T> source, Publisher<U> other) {
        super(source);
        this.other = Objects.requireNonNull(other, "other");
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        Subscriber<? super T> serial = Operators.serialize(s);
        SampleMainSubscriber<? super T> main = new SampleMainSubscriber<T>(serial);
        s.onSubscribe(main);
        this.other.subscribe(new SampleOtherSubscriber(main));
        this.source.subscribe(main);
    }

    static final class SampleOtherSubscriber<T, U>
    implements Subscriber<U> {
        final SampleMainSubscriber<T> main;

        public SampleOtherSubscriber(SampleMainSubscriber<T> main) {
            this.main = main;
        }

        public void onSubscribe(Subscription s) {
            this.main.setOther(s);
        }

        public void onNext(U t) {
            SampleMainSubscriber<T> m = this.main;
            T v = m.getAndNullValue();
            if (v != null) {
                if (m.requested != 0L) {
                    m.actual.onNext(v);
                    if (m.requested != Long.MAX_VALUE) {
                        m.decrement();
                    }
                    return;
                }
                m.cancel();
                m.actual.onError((Throwable)Exceptions.failWithOverflow("Can't signal value due to lack of requests"));
            }
        }

        public void onError(Throwable t) {
            SampleMainSubscriber<T> m = this.main;
            m.cancelMain();
            m.actual.onError(t);
        }

        public void onComplete() {
            SampleMainSubscriber<T> m = this.main;
            m.cancelMain();
            m.actual.onComplete();
        }
    }

    static final class SampleMainSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        final Subscriber<? super T> actual;
        volatile T value;
        static final AtomicReferenceFieldUpdater<SampleMainSubscriber, Object> VALUE = AtomicReferenceFieldUpdater.newUpdater(SampleMainSubscriber.class, Object.class, "value");
        volatile Subscription main;
        static final AtomicReferenceFieldUpdater<SampleMainSubscriber, Subscription> MAIN = AtomicReferenceFieldUpdater.newUpdater(SampleMainSubscriber.class, Subscription.class, "main");
        volatile Subscription other;
        static final AtomicReferenceFieldUpdater<SampleMainSubscriber, Subscription> OTHER = AtomicReferenceFieldUpdater.newUpdater(SampleMainSubscriber.class, Subscription.class, "other");
        volatile long requested;
        static final AtomicLongFieldUpdater<SampleMainSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(SampleMainSubscriber.class, "requested");

        public SampleMainSubscriber(Subscriber<? super T> actual) {
            this.actual = actual;
        }

        public void onSubscribe(Subscription s) {
            if (!MAIN.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.main != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
                return;
            }
            s.request(Long.MAX_VALUE);
        }

        void cancelMain() {
            Subscription s = this.main;
            if (s != Operators.cancelledSubscription() && (s = MAIN.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        void cancelOther() {
            Subscription s = this.other;
            if (s != Operators.cancelledSubscription() && (s = OTHER.getAndSet(this, Operators.cancelledSubscription())) != null && s != Operators.cancelledSubscription()) {
                s.cancel();
            }
        }

        void setOther(Subscription s) {
            if (!OTHER.compareAndSet(this, null, s)) {
                s.cancel();
                if (this.other != Operators.cancelledSubscription()) {
                    Operators.reportSubscriptionSet();
                }
                return;
            }
            s.request(Long.MAX_VALUE);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
            }
        }

        public void cancel() {
            this.cancelMain();
            this.cancelOther();
        }

        public void onNext(T t) {
            this.value = t;
        }

        public void onError(Throwable t) {
            this.cancelOther();
            this.actual.onError(t);
        }

        public void onComplete() {
            this.cancelOther();
            this.actual.onComplete();
        }

        T getAndNullValue() {
            return VALUE.getAndSet(this, null);
        }

        void decrement() {
            REQUESTED.decrementAndGet(this);
        }
    }
}

