/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Loopback;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxRetryWhen<T>
extends FluxSource<T, T> {
    final Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory;

    public FluxRetryWhen(Publisher<? extends T> source, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory) {
        super(source);
        this.whenSourceFactory = Objects.requireNonNull(whenSourceFactory, "whenSourceFactory");
    }

    static <T> void subscribe(Subscriber<? super T> s, Function<? super Flux<Throwable>, ? extends Publisher<?>> whenSourceFactory, Publisher<? extends T> source) {
        Publisher<?> p;
        RetryWhenOtherSubscriber other = new RetryWhenOtherSubscriber();
        Subscriber<Throwable> signaller = Operators.serialize(other.completionSignal);
        signaller.onSubscribe(Operators.emptySubscription());
        Subscriber<? super T> serial = Operators.serialize(s);
        RetryWhenMainSubscriber<? extends T> main = new RetryWhenMainSubscriber<T>(serial, signaller, source);
        other.main = main;
        serial.onSubscribe(main);
        try {
            p = whenSourceFactory.apply(other);
        }
        catch (Throwable e) {
            s.onError(Operators.onOperatorError(e));
            return;
        }
        if (p == null) {
            s.onError(Operators.onOperatorError(new NullPointerException("The whenSourceFactory returned a null Publisher")));
            return;
        }
        p.subscribe((Subscriber)other);
        if (!main.cancelled) {
            source.subscribe(main);
        }
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxRetryWhen.subscribe(s, this.whenSourceFactory, this.source);
    }

    static final class RetryWhenOtherSubscriber
    extends Flux<Throwable>
    implements Subscriber<Object>,
    Loopback {
        RetryWhenMainSubscriber<?> main;
        final DirectProcessor<Throwable> completionSignal = new DirectProcessor();

        RetryWhenOtherSubscriber() {
        }

        public void onSubscribe(Subscription s) {
            this.main.setWhen(s);
        }

        public void onNext(Object t) {
            this.main.resubscribe();
        }

        public void onError(Throwable t) {
            this.main.whenError(t);
        }

        public void onComplete() {
            this.main.whenComplete();
        }

        public void subscribe(Subscriber<? super Throwable> s) {
            this.completionSignal.subscribe((Subscriber<Throwable>)s);
        }

        @Override
        public Object connectedInput() {
            return this.main;
        }

        @Override
        public Object connectedOutput() {
            return this.completionSignal;
        }
    }

    static final class RetryWhenMainSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Operators.DeferredSubscription otherArbiter;
        final Subscriber<Throwable> signaller;
        final Publisher<? extends T> source;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryWhenMainSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryWhenMainSubscriber.class, "wip");
        volatile boolean cancelled;
        long produced;

        public RetryWhenMainSubscriber(Subscriber<? super T> actual, Subscriber<Throwable> signaller, Publisher<? extends T> source) {
            super(actual);
            this.signaller = signaller;
            this.source = source;
            this.otherArbiter = new Operators.DeferredSubscription();
        }

        @Override
        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.cancelWhen();
            super.cancel();
        }

        void cancelWhen() {
            this.otherArbiter.cancel();
        }

        public void setWhen(Subscription w) {
            this.otherArbiter.set(w);
        }

        public void onNext(T t) {
            this.subscriber.onNext(t);
            ++this.produced;
        }

        @Override
        public void onError(Throwable t) {
            long p = this.produced;
            if (p != 0L) {
                this.produced = 0L;
                this.produced(p);
            }
            this.otherArbiter.request(1L);
            this.signaller.onNext((Object)t);
        }

        @Override
        public void onComplete() {
            this.otherArbiter.cancel();
            this.subscriber.onComplete();
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.cancelled) {
                        return;
                    }
                    this.source.subscribe((Subscriber)this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }

        void whenError(Throwable e) {
            this.cancelled = true;
            super.cancel();
            this.subscriber.onError(e);
        }

        void whenComplete() {
            this.cancelled = true;
            super.cancel();
            this.subscriber.onComplete();
        }
    }
}

