/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxRetryPredicate<T>
extends FluxSource<T, T> {
    final Predicate<Throwable> predicate;

    public FluxRetryPredicate(Publisher<? extends T> source, Predicate<Throwable> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        RetryPredicateSubscriber<T> parent = new RetryPredicateSubscriber<T>(this.source, s, this.predicate);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }

    static final class RetryPredicateSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T> source;
        final Predicate<Throwable> predicate;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RetryPredicateSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RetryPredicateSubscriber.class, "wip");
        long produced;

        public RetryPredicateSubscriber(Publisher<? extends T> source, Subscriber<? super T> actual, Predicate<Throwable> predicate) {
            super(actual);
            this.source = source;
            this.predicate = predicate;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            boolean b;
            try {
                b = this.predicate.test(t);
            }
            catch (Throwable e) {
                Throwable _t = Operators.onOperatorError(e);
                _t.addSuppressed(t);
                this.subscriber.onError(_t);
                return;
            }
            if (b) {
                this.resubscribe();
            } else {
                this.subscriber.onError(t);
            }
        }

        @Override
        public void onComplete() {
            this.subscriber.onComplete();
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    this.source.subscribe((Subscriber)this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

