/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.BooleanSupplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxRepeatPredicate<T>
extends FluxSource<T, T> {
    final BooleanSupplier predicate;

    public FluxRepeatPredicate(Publisher<? extends T> source, BooleanSupplier predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        RepeatPredicateSubscriber<T> parent = new RepeatPredicateSubscriber<T>(this.source, s, this.predicate);
        s.onSubscribe(parent);
        if (!parent.isCancelled()) {
            parent.resubscribe();
        }
    }

    static final class RepeatPredicateSubscriber<T>
    extends Operators.MultiSubscriptionSubscriber<T, T> {
        final Publisher<? extends T> source;
        final BooleanSupplier predicate;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<RepeatPredicateSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(RepeatPredicateSubscriber.class, "wip");
        long produced;

        public RepeatPredicateSubscriber(Publisher<? extends T> source, Subscriber<? super T> actual, BooleanSupplier predicate) {
            super(actual);
            this.source = source;
            this.predicate = predicate;
        }

        public void onNext(T t) {
            ++this.produced;
            this.subscriber.onNext(t);
        }

        @Override
        public void onComplete() {
            boolean b;
            try {
                b = this.predicate.getAsBoolean();
            }
            catch (Throwable e) {
                this.subscriber.onError(Operators.onOperatorError(e));
                return;
            }
            if (b) {
                this.resubscribe();
            } else {
                this.subscriber.onComplete();
            }
        }

        void resubscribe() {
            if (WIP.getAndIncrement(this) == 0) {
                do {
                    if (this.isCancelled()) {
                        return;
                    }
                    long c = this.produced;
                    if (c != 0L) {
                        this.produced = 0L;
                        this.produced(c);
                    }
                    this.source.subscribe((Subscriber)this);
                } while (WIP.decrementAndGet(this) != 0);
            }
        }
    }
}

