/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Exceptions;
import reactor.core.Trackable;
import reactor.core.publisher.BlockingSink;
import reactor.core.publisher.DelegateProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;
import reactor.core.publisher.UnicastProcessor;

public abstract class FluxProcessor<IN, OUT>
extends Flux<OUT>
implements Processor<IN, OUT>,
Trackable {
    public static <T> FluxProcessor<Publisher<? extends T>, T> switchOnNext() {
        UnicastProcessor emitter = UnicastProcessor.create();
        FluxProcessor p = FluxProcessor.wrap(emitter, FluxProcessor.switchOnNext(emitter));
        return p;
    }

    public static <IN, OUT> FluxProcessor<IN, OUT> wrap(Subscriber<IN> upstream, Publisher<OUT> downstream) {
        return new DelegateProcessor<IN, OUT>(downstream, upstream);
    }

    public FluxProcessor<IN, OUT> connect() {
        this.onSubscribe(Operators.emptySubscription());
        return this;
    }

    public final BlockingSink<IN> connectSink() {
        return this.connectSink(true);
    }

    public final BlockingSink<IN> connectSink(boolean autostart) {
        return BlockingSink.create(this, autostart);
    }

    @Override
    public long getCapacity() {
        return Long.MAX_VALUE;
    }

    public final FluxProcessor<IN, OUT> serialize() {
        return new DelegateProcessor(this, Operators.serialize(this));
    }

    public void subscribe(Subscriber<? super OUT> s) {
        if (s == null) {
            throw Exceptions.argumentIsNullException();
        }
    }
}

