/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.BufferOverflowStrategy;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxOnBackpressureBufferStrategy<O>
extends FluxSource<O, O> {
    final Consumer<? super O> onBufferOverflow;
    final int bufferSize;
    final boolean delayError;
    final BufferOverflowStrategy bufferOverflowStrategy;

    public FluxOnBackpressureBufferStrategy(Publisher<? extends O> source, int bufferSize, Consumer<? super O> onBufferOverflow, BufferOverflowStrategy bufferOverflowStrategy) {
        super(source);
        this.bufferSize = bufferSize;
        this.onBufferOverflow = onBufferOverflow;
        this.bufferOverflowStrategy = bufferOverflowStrategy;
        this.delayError = onBufferOverflow != null;
    }

    @Override
    public void subscribe(Subscriber<? super O> s) {
        this.source.subscribe(new BackpressureBufferDropOldestSubscriber<O>(s, this.bufferSize, this.delayError, this.onBufferOverflow, this.bufferOverflowStrategy));
    }

    @Override
    public long getPrefetch() {
        return Long.MAX_VALUE;
    }

    static final class BackpressureBufferDropOldestSubscriber<T>
    implements Subscriber<T>,
    Subscription,
    Trackable,
    Producer,
    Receiver {
        final Subscriber<? super T> actual;
        final int bufferSize;
        final Deque<T> queue;
        final Consumer<? super T> onOverflow;
        final boolean delayError;
        final BufferOverflowStrategy overflowStrategy;
        Subscription s;
        volatile boolean cancelled;
        volatile boolean done;
        Throwable error;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<BackpressureBufferDropOldestSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(BackpressureBufferDropOldestSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<BackpressureBufferDropOldestSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(BackpressureBufferDropOldestSubscriber.class, "requested");

        public BackpressureBufferDropOldestSubscriber(Subscriber<? super T> actual, int bufferSize, boolean delayError, Consumer<? super T> onOverflow, BufferOverflowStrategy overflowStrategy) {
            this.actual = actual;
            this.delayError = delayError;
            this.onOverflow = onOverflow;
            this.overflowStrategy = overflowStrategy;
            this.bufferSize = bufferSize;
            this.queue = new ArrayDeque<T>(bufferSize);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request(Long.MAX_VALUE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            Deque<T> dq;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            boolean callOnOverflow = false;
            boolean callOnError = false;
            T overflowElement = t;
            Deque<T> deque = dq = this.queue;
            synchronized (deque) {
                if (dq.size() == this.bufferSize) {
                    callOnOverflow = true;
                    switch (this.overflowStrategy) {
                        case DROP_OLDEST: {
                            overflowElement = dq.pollFirst();
                            dq.offer(t);
                            break;
                        }
                        case DROP_LATEST: {
                            break;
                        }
                        default: {
                            callOnError = true;
                            break;
                        }
                    }
                } else {
                    dq.offer(t);
                }
            }
            if (callOnOverflow && this.onOverflow != null) {
                try {
                    this.onOverflow.accept(overflowElement);
                }
                catch (Throwable e) {
                    Throwable ex = Operators.onOperatorError(this.s, e, overflowElement);
                    this.onError(ex);
                    return;
                }
            }
            if (callOnError) {
                Throwable ex = Operators.onOperatorError(this.s, Exceptions.failWithOverflow(), overflowElement);
                this.onError(ex);
            }
            if (!callOnError && !callOnOverflow) {
                this.drain();
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.error = t;
            this.done = true;
            this.drain();
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            int missed = 1;
            do {
                Subscriber<? super T> a;
                if ((a = this.actual) == null) continue;
                this.innerDrain(a);
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void innerDrain(Subscriber<? super T> a) {
            int missed = 1;
            Deque<T> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    Object t;
                    boolean d = this.done;
                    Deque<T> deque = q;
                    synchronized (deque) {
                        t = q.poll();
                    }
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (r == e) {
                    boolean empty;
                    Deque<T> deque = q;
                    synchronized (deque) {
                        empty = q.isEmpty();
                    }
                    if (this.checkTerminated(this.done, empty, a)) {
                        return;
                    }
                }
                if (e == 0L || r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    this.clear(this.queue);
                }
            }
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return this.s != null;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long getCapacity() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getPending() {
            return this.queue.size();
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<? super T> a) {
            if (this.cancelled) {
                this.s.cancel();
                this.clear(this.queue);
                return true;
            }
            if (d) {
                if (this.delayError) {
                    if (empty) {
                        Throwable e = this.error;
                        if (e != null) {
                            a.onError(e);
                        } else {
                            a.onComplete();
                        }
                        return true;
                    }
                } else {
                    Throwable e = this.error;
                    if (e != null) {
                        this.clear(this.queue);
                        a.onError(e);
                        return true;
                    }
                    if (empty) {
                        a.onComplete();
                        return true;
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear(Deque<T> dq) {
            Deque<T> deque = dq;
            synchronized (deque) {
                dq.clear();
            }
        }
    }
}

