/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedTransferQueue;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.Receiver;
import reactor.core.publisher.AssemblyOp;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class FluxOnAssembly<T>
extends FluxSource<T, T>
implements Fuseable,
AssemblyOp {
    final String stacktrace;
    static final boolean fullStackTrace = Boolean.parseBoolean(System.getProperty("reactor.trace.assembly.fullstacktrace", "false"));

    public FluxOnAssembly(Publisher<? extends T> source, boolean trace) {
        super(source);
        this.stacktrace = trace ? FluxOnAssembly.takeStacktrace(source) : null;
    }

    static Publisher<?> getParentOrThis(Publisher<?> parent) {
        Object next = parent;
        while (next instanceof Receiver) {
            Receiver r = (Receiver)next;
            if (!((next = r.upstream()) instanceof AssemblyOp)) continue;
            return next;
        }
        return parent;
    }

    static String takeStacktrace(Publisher<?> source) {
        StackTraceElement[] stes = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder(null != source ? "\nAssembly trace from producer [" + source.getClass().getName() + "] :\n" : "");
        for (StackTraceElement e : stes) {
            String row = e.toString();
            if (!fullStackTrace && (e.getLineNumber() <= 1 || row.contains("reactor.core.publisher.Flux.onAssembly") || row.contains("reactor.core.publisher.Mono.onAssembly") || row.contains("reactor.core.publisher.ParallelFlux.onAssembly") || row.contains("reactor.core.publisher.SignalLogger") || row.contains("FluxOnAssembly.") || row.contains("MonoOnAssembly.") || row.contains("MonoCallableOnAssembly.") || row.contains("FluxCallableOnAssembly.") || row.contains("OnOperatorCreate") || row.contains("operatorStacktrace") || row.contains("reactor.core.publisher.Hooks") || row.contains(".junit.runner") || row.contains(".junit4.runner") || row.contains(".junit.internal") || row.contains("sun.reflect") || row.contains("useTraceAssembly") || row.contains("java.lang.Thread.") || row.contains("ThreadPoolExecutor") || row.contains("org.apache.catalina.") || row.contains("org.apache.tomcat.") || row.contains("com.intellij.") || row.contains("java.lang.reflect"))) continue;
            sb.append("\t").append(row).append("\n");
        }
        return sb.toString();
    }

    static <T> void subscribe(Subscriber<? super T> s, Publisher<? extends T> source, String stacktrace, Publisher<T> parent) {
        if (stacktrace != null) {
            if (s instanceof Fuseable.ConditionalSubscriber) {
                Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
                source.subscribe(new OnAssemblyConditionalSubscriber(cs, stacktrace, parent));
            } else {
                source.subscribe(new OnAssemblySubscriber<T>(s, stacktrace, parent));
            }
        }
    }

    static String extract(String source, boolean skipFirst) {
        String usercode = null;
        String last = null;
        boolean first = skipFirst;
        for (String s : source.split("\n")) {
            if (s.isEmpty()) continue;
            if (first) {
                first = false;
                continue;
            }
            if (!s.contains("reactor.core.publisher")) {
                usercode = s.substring(s.indexOf(40));
                break;
            }
            last = s.replace("reactor.core.publisher.", "");
            last = last.substring(0, last.indexOf("("));
        }
        return (skipFirst && last != null ? last : "") + usercode;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        FluxOnAssembly.subscribe(s, this.source, this.stacktrace, this);
    }

    static final class OnAssemblyConditionalSubscriber<T>
    extends OnAssemblySubscriber<T>
    implements Fuseable.ConditionalSubscriber<T> {
        final Fuseable.ConditionalSubscriber<? super T> actualCS;

        OnAssemblyConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, String stacktrace, Publisher<?> parent) {
            super(actual, stacktrace, parent);
            this.actualCS = actual;
        }

        @Override
        public boolean tryOnNext(T t) {
            return this.actualCS.tryOnNext(t);
        }
    }

    static class OnAssemblySubscriber<T>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<T> {
        final String stacktrace;
        final Subscriber<? super T> actual;
        final Publisher<?> parent;
        Fuseable.QueueSubscription<T> qs;
        Subscription s;
        int fusionMode;

        OnAssemblySubscriber(Subscriber<? super T> actual, String stacktrace, Publisher<?> parent) {
            this.actual = actual;
            this.stacktrace = stacktrace;
            this.parent = parent;
        }

        public final void onNext(T t) {
            this.actual.onNext(t);
        }

        public final void onError(Throwable t) {
            this.fail(t);
            this.actual.onError(t);
        }

        public final void onComplete() {
            this.actual.onComplete();
        }

        @Override
        public final int requestFusion(int requestedMode) {
            Fuseable.QueueSubscription<T> qs = this.qs;
            if (qs != null) {
                int m = qs.requestFusion(requestedMode);
                if (m != 0) {
                    this.fusionMode = m;
                }
                return m;
            }
            return 0;
        }

        final void fail(Throwable t) {
            boolean set = false;
            if (t.getSuppressed().length > 0) {
                for (Throwable e : t.getSuppressed()) {
                    if (!(e instanceof OnAssemblyException)) continue;
                    OnAssemblyException oae = (OnAssemblyException)e;
                    oae.add(this.parent, this.stacktrace);
                    set = true;
                    break;
                }
            }
            if (!set) {
                t.addSuppressed(new OnAssemblyException(this.stacktrace, this.parent));
            }
        }

        @Override
        public final boolean isEmpty() {
            try {
                return this.qs.isEmpty();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.fail(ex);
                throw ex;
            }
        }

        public final void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.qs = Operators.as(s);
                this.actual.onSubscribe((Subscription)this);
            }
        }

        @Override
        public final int size() {
            return this.qs.size();
        }

        @Override
        public final void clear() {
            this.qs.clear();
        }

        public final void request(long n) {
            this.s.request(n);
        }

        public final void cancel() {
            this.s.cancel();
        }

        @Override
        public final T poll() {
            try {
                return (T)this.qs.poll();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.fail(ex);
                throw ex;
            }
        }
    }

    static final class OnAssemblyException
    extends RuntimeException {
        final Publisher<?> parent;
        final Map<Integer, Map<Integer, String>> stackByPublisher = new HashMap<Integer, Map<Integer, String>>();
        private static final long serialVersionUID = 5278398300974016773L;

        public OnAssemblyException(String message, Publisher<?> parent) {
            super(message);
            HashMap<Integer, String> thiz = new HashMap<Integer, String>();
            thiz.put(parent.hashCode(), FluxOnAssembly.extract(message, true));
            this.stackByPublisher.put(0, thiz);
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getMessage() {
            StringBuilder sb = new StringBuilder(super.getMessage()).append("Composition chain until failing Operator :\n");
            LinkedTransferQueue<Tuple2<Integer, Integer>> nexts = new LinkedTransferQueue<Tuple2<Integer, Integer>>();
            nexts.add(Tuples.of(0, 0));
            Map<Integer, Map<Integer, String>> map = this.stackByPublisher;
            synchronized (map) {
                Tuple2 next;
                while ((next = (Tuple2)nexts.poll()) != null) {
                    Map<Integer, String> op = this.stackByPublisher.get(next.getT2());
                    if (op == null) continue;
                    int i = (Integer)next.getT1();
                    for (Map.Entry<Integer, String> entry : op.entrySet()) {
                        this.mapLine(i, sb, entry.getValue());
                        nexts.add(Tuples.of(i, entry.getKey()));
                        ++i;
                    }
                }
            }
            return sb.toString();
        }

        void mapLine(int indent, StringBuilder sb, String s) {
            for (int i = 0; i < indent; ++i) {
                sb.append("\t");
            }
            sb.append("\t|_").append(s).append("\n");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(Publisher<?> parent, String stacktrace) {
            int key = FluxOnAssembly.getParentOrThis(parent).hashCode();
            Map<Integer, Map<Integer, String>> map = this.stackByPublisher;
            synchronized (map) {
                this.stackByPublisher.compute(key, (k, s) -> {
                    if (s == null) {
                        s = new HashMap<Integer, String>();
                    }
                    s.put(parent.hashCode(), FluxOnAssembly.extract(stacktrace, true));
                    return s;
                });
            }
        }
    }
}

