/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxMapFuseable<T, R>
extends FluxSource<T, R>
implements Fuseable {
    final Function<? super T, ? extends R> mapper;

    public FluxMapFuseable(Publisher<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public Function<? super T, ? extends R> mapper() {
        return this.mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new MapFuseableConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new MapFuseableSubscriber<T, R>(s, this.mapper));
    }

    static final class MapFuseableConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Fuseable.SynchronousSubscription<R>,
    Trackable {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        public MapFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                R v;
                try {
                    v = this.mapper.apply(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (v == null) {
                    this.done = true;
                    this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                    return;
                }
                this.actual.onNext(v);
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            int m = this.sourceMode;
            if (m == 0) {
                R v;
                try {
                    v = this.mapper.apply(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return true;
                }
                if (v == null) {
                    this.done = true;
                    this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                    return true;
                }
                return this.actual.tryOnNext(v);
            }
            if (m == 2) {
                this.actual.onNext(null);
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.mapper;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public R poll() {
            Object v = this.s.poll();
            if (v != null) {
                R u = this.mapper.apply(v);
                if (u == null) {
                    throw new NullPointerException();
                }
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? ((requestedMode & 1) != 0 ? this.s.requestFusion(1) : 0) : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }

    static final class MapFuseableSubscriber<T, R>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Fuseable.SynchronousSubscription<R>,
    Trackable {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Fuseable.QueueSubscription<T> s;
        int sourceMode;

        public MapFuseableSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                R v;
                try {
                    v = this.mapper.apply(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (v == null) {
                    this.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                    return;
                }
                this.actual.onNext(v);
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.mapper;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public R poll() {
            Object v = this.s.poll();
            if (v != null) {
                R u = this.mapper.apply(v);
                if (u == null) {
                    throw new NullPointerException();
                }
                return u;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? 0 : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }
}

