/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxMapFuseable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxMap<T, R>
extends FluxSource<T, R> {
    final Function<? super T, ? extends R> mapper;

    public FluxMap(Publisher<? extends T> source, Function<? super T, ? extends R> mapper) {
        super(source);
        this.mapper = Objects.requireNonNull(mapper, "mapper");
    }

    public Function<? super T, ? extends R> mapper() {
        return this.mapper;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (this.source instanceof Fuseable) {
            this.source.subscribe(new FluxMapFuseable.MapFuseableSubscriber<T, R>(s, this.mapper));
            return;
        }
        if (s instanceof Fuseable.ConditionalSubscriber) {
            Fuseable.ConditionalSubscriber cs = (Fuseable.ConditionalSubscriber)s;
            this.source.subscribe(new MapConditionalSubscriber<T, R>(cs, this.mapper));
            return;
        }
        this.source.subscribe(new MapSubscriber<T, R>(s, this.mapper));
    }

    static final class MapConditionalSubscriber<T, R>
    implements Fuseable.ConditionalSubscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable {
        final Fuseable.ConditionalSubscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Subscription s;

        public MapConditionalSubscriber(Fuseable.ConditionalSubscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                v = this.mapper.apply(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                return;
            }
            this.actual.onNext(v);
        }

        @Override
        public boolean tryOnNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t);
                return true;
            }
            try {
                v = this.mapper.apply(t);
            }
            catch (Throwable e) {
                this.done = true;
                this.onError(Operators.onOperatorError(this.s, e, t));
                return true;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                return true;
            }
            return this.actual.tryOnNext(v);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.mapper;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }

    static final class MapSubscriber<T, R>
    implements Subscriber<T>,
    Receiver,
    Producer,
    Loopback,
    Subscription,
    Trackable {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends R> mapper;
        boolean done;
        Subscription s;

        public MapSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            R v;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                v = this.mapper.apply(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (v == null) {
                this.done = true;
                this.actual.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null value."), t));
                return;
            }
            this.actual.onNext(v);
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.mapper;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }
    }
}

