/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.MultiProducer;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.GroupedFlux;
import reactor.core.publisher.Operators;

final class FluxGroupBy<T, K, V>
extends FluxSource<T, GroupedFlux<K, V>>
implements Fuseable {
    final Function<? super T, ? extends K> keySelector;
    final Function<? super T, ? extends V> valueSelector;
    final Supplier<? extends Queue<V>> groupQueueSupplier;
    final Supplier<? extends Queue<GroupedFlux<K, V>>> mainQueueSupplier;
    final int prefetch;

    public FluxGroupBy(Publisher<? extends T> source, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector, Supplier<? extends Queue<GroupedFlux<K, V>>> mainQueueSupplier, Supplier<? extends Queue<V>> groupQueueSupplier, int prefetch) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.keySelector = Objects.requireNonNull(keySelector, "keySelector");
        this.valueSelector = Objects.requireNonNull(valueSelector, "valueSelector");
        this.mainQueueSupplier = Objects.requireNonNull(mainQueueSupplier, "mainQueueSupplier");
        this.groupQueueSupplier = Objects.requireNonNull(groupQueueSupplier, "groupQueueSupplier");
        this.prefetch = prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super GroupedFlux<K, V>> s) {
        Queue<GroupedFlux<K, V>> q;
        try {
            q = this.mainQueueSupplier.get();
        }
        catch (Throwable ex) {
            Operators.error(s, Operators.onOperatorError(ex));
            return;
        }
        if (q == null) {
            Operators.error(s, new NullPointerException("The mainQueueSupplier returned a null queue"));
            return;
        }
        this.source.subscribe(new GroupByMain<T, K, V>(s, q, this.groupQueueSupplier, this.prefetch, this.keySelector, this.valueSelector));
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    static final class UnicastGroupedFlux<K, V>
    extends GroupedFlux<K, V>
    implements Fuseable,
    Fuseable.QueueSubscription<V>,
    Producer,
    Receiver,
    Trackable {
        final K key;
        final int limit;
        final Queue<V> queue;
        volatile GroupByMain<?, K, V> parent;
        static final AtomicReferenceFieldUpdater<UnicastGroupedFlux, GroupByMain> PARENT = AtomicReferenceFieldUpdater.newUpdater(UnicastGroupedFlux.class, GroupByMain.class, "parent");
        volatile boolean done;
        Throwable error;
        volatile Subscriber<? super V> actual;
        static final AtomicReferenceFieldUpdater<UnicastGroupedFlux, Subscriber> ACTUAL = AtomicReferenceFieldUpdater.newUpdater(UnicastGroupedFlux.class, Subscriber.class, "actual");
        volatile boolean cancelled;
        volatile int once;
        static final AtomicIntegerFieldUpdater<UnicastGroupedFlux> ONCE = AtomicIntegerFieldUpdater.newUpdater(UnicastGroupedFlux.class, "once");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<UnicastGroupedFlux> WIP = AtomicIntegerFieldUpdater.newUpdater(UnicastGroupedFlux.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<UnicastGroupedFlux> REQUESTED = AtomicLongFieldUpdater.newUpdater(UnicastGroupedFlux.class, "requested");
        volatile boolean enableOperatorFusion;
        int produced;

        @Override
        public K key() {
            return this.key;
        }

        public UnicastGroupedFlux(K key, Queue<V> queue, GroupByMain<?, K, V> parent, int prefetch) {
            this.key = key;
            this.queue = queue;
            this.parent = parent;
            this.limit = prefetch - (prefetch >> 2);
        }

        void doTerminate() {
            GroupByMain<?, K, V> r = this.parent;
            if (r != null && PARENT.compareAndSet(this, r, null)) {
                r.groupTerminated(this.key);
            }
        }

        void drainRegular(Subscriber<? super V> a) {
            int missed = 1;
            Queue<V> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; r != e; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    V t = q.poll();
                    boolean bl = empty = t == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(t);
                }
                if (r == e && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L) continue;
                GroupByMain<?, K, V> main = this.parent;
                if (main != null) {
                    main.requestInner(e);
                }
                if (r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainFused(Subscriber<? super V> a) {
            int missed = 1;
            Queue<V> q = this.queue;
            do {
                if (this.cancelled) {
                    q.clear();
                    this.actual = null;
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                this.actual = null;
                Throwable ex = this.error;
                if (ex != null) {
                    a.onError(ex);
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drain() {
            Subscriber<? super V> a = this.actual;
            if (a != null) {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.enableOperatorFusion) {
                    this.drainFused(a);
                } else {
                    this.drainRegular(a);
                }
            }
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<?> q) {
            if (this.cancelled) {
                q.clear();
                this.actual = null;
                return true;
            }
            if (d && empty) {
                Throwable e = this.error;
                this.actual = null;
                if (e != null) {
                    a.onError(e);
                } else {
                    a.onComplete();
                }
                return true;
            }
            return false;
        }

        public void onNext(V t) {
            if (this.done || this.cancelled) {
                return;
            }
            Subscriber<? super V> a = this.actual;
            if (!this.queue.offer(t)) {
                this.onError(Exceptions.failWithOverflow("The queue is full"));
                return;
            }
            if (this.enableOperatorFusion) {
                if (a != null) {
                    a.onNext(null);
                }
            } else {
                this.drain();
            }
        }

        public void onError(Throwable t) {
            if (this.done || this.cancelled) {
                return;
            }
            this.error = t;
            this.done = true;
            this.doTerminate();
            this.drain();
        }

        public void onComplete() {
            if (this.done || this.cancelled) {
                return;
            }
            this.done = true;
            this.doTerminate();
            this.drain();
        }

        public void subscribe(Subscriber<? super V> s) {
            if (this.once == 0 && ONCE.compareAndSet(this, 0, 1)) {
                s.onSubscribe((Subscription)this);
                this.actual = s;
                if (this.cancelled) {
                    this.actual = null;
                } else {
                    this.drain();
                }
            } else {
                s.onError((Throwable)new IllegalStateException("This processor allows only a single Subscriber"));
            }
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (this.cancelled) {
                return;
            }
            this.cancelled = true;
            this.doTerminate();
            if (!this.enableOperatorFusion && WIP.getAndIncrement(this) == 0) {
                this.queue.clear();
            }
        }

        @Override
        public V poll() {
            V v = this.queue.poll();
            if (v != null) {
                ++this.produced;
            } else {
                int p = this.produced;
                if (p != 0) {
                    this.produced = 0;
                    GroupByMain<?, K, V> main = this.parent;
                    if (main != null) {
                        main.requestInner(p);
                    }
                }
            }
            return v;
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 2) != 0) {
                this.enableOperatorFusion = true;
                return 2;
            }
            return 0;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return this.once == 1 && !this.done && !this.cancelled;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.parent;
        }

        @Override
        public long getCapacity() {
            GroupByMain<?, K, V> parent = this.parent;
            return parent != null ? (long)parent.prefetch : -1L;
        }

        @Override
        public long getPending() {
            return this.queue == null || this.done ? -1L : (long)this.queue.size();
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public long expectedFromUpstream() {
            return this.produced;
        }

        @Override
        public long limit() {
            return this.limit;
        }
    }

    static final class GroupByMain<T, K, V>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<GroupedFlux<K, V>>,
    MultiProducer,
    Producer,
    Trackable,
    Receiver {
        final Function<? super T, ? extends K> keySelector;
        final Function<? super T, ? extends V> valueSelector;
        final Subscriber<? super GroupedFlux<K, V>> actual;
        final Queue<GroupedFlux<K, V>> queue;
        final Supplier<? extends Queue<V>> groupQueueSupplier;
        final int prefetch;
        final ConcurrentMap<K, UnicastGroupedFlux<K, V>> groupMap;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<GroupByMain> WIP = AtomicIntegerFieldUpdater.newUpdater(GroupByMain.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<GroupByMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(GroupByMain.class, "requested");
        volatile boolean done;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<GroupByMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(GroupByMain.class, Throwable.class, "error");
        volatile int cancelled;
        static final AtomicIntegerFieldUpdater<GroupByMain> CANCELLED = AtomicIntegerFieldUpdater.newUpdater(GroupByMain.class, "cancelled");
        volatile int groupCount;
        static final AtomicIntegerFieldUpdater<GroupByMain> GROUP_COUNT = AtomicIntegerFieldUpdater.newUpdater(GroupByMain.class, "groupCount");
        Subscription s;
        volatile boolean enableAsyncFusion;

        public GroupByMain(Subscriber<? super GroupedFlux<K, V>> actual, Queue<GroupedFlux<K, V>> queue, Supplier<? extends Queue<V>> groupQueueSupplier, int prefetch, Function<? super T, ? extends K> keySelector, Function<? super T, ? extends V> valueSelector) {
            this.actual = actual;
            this.queue = queue;
            this.groupQueueSupplier = groupQueueSupplier;
            this.prefetch = prefetch;
            this.groupMap = new ConcurrentHashMap<K, UnicastGroupedFlux<K, V>>();
            this.keySelector = keySelector;
            this.valueSelector = valueSelector;
            GROUP_COUNT.lazySet(this, 1);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            V value;
            K key;
            try {
                key = this.keySelector.apply(t);
                value = this.valueSelector.apply(t);
            }
            catch (Throwable ex) {
                this.onError(Operators.onOperatorError(this.s, ex, t));
                return;
            }
            if (key == null) {
                this.onError(Operators.onOperatorError(this.s, new NullPointerException("The keySelector returned a null value"), t));
                return;
            }
            if (value == null) {
                this.onError(Operators.onOperatorError(this.s, new NullPointerException("The valueSelector returned a null value"), t));
                return;
            }
            UnicastGroupedFlux<K, V> g = (UnicastGroupedFlux<K, V>)this.groupMap.get(key);
            if (g == null) {
                if (this.cancelled == 0) {
                    Queue<V> q;
                    try {
                        q = this.groupQueueSupplier.get();
                    }
                    catch (Throwable ex) {
                        this.onError(Operators.onOperatorError(this.s, ex, t));
                        return;
                    }
                    GROUP_COUNT.getAndIncrement(this);
                    g = new UnicastGroupedFlux<K, V>(key, q, this, this.prefetch);
                    g.onNext(value);
                    this.groupMap.put(key, g);
                    this.queue.offer(g);
                    this.drain();
                }
            } else {
                g.onNext(value);
            }
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            for (UnicastGroupedFlux g : this.groupMap.values()) {
                g.onComplete();
            }
            this.groupMap.clear();
            GROUP_COUNT.decrementAndGet(this);
            this.done = true;
            this.drain();
        }

        @Override
        public long getCapacity() {
            return this.prefetch;
        }

        @Override
        public long getPending() {
            return this.queue.size();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && this.cancelled != 1 && !this.done;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled == 1;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public Iterator<?> downstreams() {
            return this.groupMap.values().iterator();
        }

        @Override
        public long downstreamCount() {
            return GROUP_COUNT.get(this);
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        void signalAsyncError() {
            Throwable e = Exceptions.terminate(ERROR, this);
            this.groupCount = 0;
            for (UnicastGroupedFlux g : this.groupMap.values()) {
                g.onError(e);
            }
            this.actual.onError(e);
            this.groupMap.clear();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (CANCELLED.compareAndSet(this, 0, 1)) {
                if (GROUP_COUNT.decrementAndGet(this) == 0) {
                    this.s.cancel();
                } else if (!this.enableAsyncFusion && WIP.getAndIncrement(this) == 0) {
                    GroupedFlux<K, V> g;
                    while ((g = this.queue.poll()) != null) {
                        ((UnicastGroupedFlux)g).cancel();
                    }
                    if (WIP.decrementAndGet(this) == 0) {
                        return;
                    }
                    this.drainLoop();
                }
            }
        }

        void groupTerminated(K key) {
            if (this.groupCount == 0) {
                return;
            }
            this.groupMap.remove(key);
            if (GROUP_COUNT.decrementAndGet(this) == 0) {
                this.s.cancel();
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.enableAsyncFusion) {
                this.drainFused();
            } else {
                this.drainLoop();
            }
        }

        void drainFused() {
            int missed = 1;
            Subscriber<? super GroupedFlux<K, V>> a = this.actual;
            Queue<GroupedFlux<K, V>> q = this.queue;
            do {
                if (this.cancelled != 0) {
                    q.clear();
                    return;
                }
                boolean d = this.done;
                a.onNext(null);
                if (!d) continue;
                Throwable ex = this.error;
                if (ex != null) {
                    this.signalAsyncError();
                } else {
                    a.onComplete();
                }
                return;
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        void drainLoop() {
            int missed = 1;
            Subscriber<? super GroupedFlux<K, V>> a = this.actual;
            Queue<GroupedFlux<K, V>> q = this.queue;
            do {
                long e;
                long r = this.requested;
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    boolean d = this.done;
                    GroupedFlux<K, V> v = q.poll();
                    boolean bl = empty = v == null;
                    if (this.checkTerminated(d, empty, a, q)) {
                        return;
                    }
                    if (empty) break;
                    a.onNext(v);
                }
                if (e == r && this.checkTerminated(this.done, q.isEmpty(), a, q)) {
                    return;
                }
                if (e == 0L) continue;
                this.s.request(e);
                if (r == Long.MAX_VALUE) continue;
                REQUESTED.addAndGet(this, -e);
            } while ((missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a, Queue<GroupedFlux<K, V>> q) {
            if (d) {
                Throwable e = this.error;
                if (e != null && e != Exceptions.TERMINATED) {
                    this.queue.clear();
                    this.signalAsyncError();
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        @Override
        public GroupedFlux<K, V> poll() {
            return this.queue.poll();
        }

        @Override
        public int size() {
            return this.queue.size();
        }

        @Override
        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        @Override
        public void clear() {
            this.queue.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            if (requestedMode == 3 || requestedMode == 2) {
                this.enableAsyncFusion = true;
                return 2;
            }
            return 0;
        }

        void requestInner(long n) {
            this.s.request(n);
        }
    }
}

