/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.publisher.FluxIterable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxFlattenIterable<T, R>
extends FluxSource<T, R>
implements Fuseable {
    final Function<? super T, ? extends Iterable<? extends R>> mapper;
    final int prefetch;
    final Supplier<Queue<T>> queueSupplier;

    public FluxFlattenIterable(Publisher<? extends T> source, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch, Supplier<Queue<T>> queueSupplier) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.prefetch = prefetch;
        this.queueSupplier = Objects.requireNonNull(queueSupplier, "queueSupplier");
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (this.source instanceof Callable) {
            Iterator<? extends R> it;
            Object v;
            try {
                v = ((Callable)this.source).call();
            }
            catch (Throwable ex) {
                Operators.error(s, Operators.onOperatorError(ex));
                return;
            }
            if (v == null) {
                Operators.complete(s);
                return;
            }
            try {
                Iterable<R> iter = this.mapper.apply(v);
                it = iter.iterator();
            }
            catch (Throwable ex) {
                Operators.error(s, Operators.onOperatorError(ex));
                return;
            }
            FluxIterable.subscribe(s, it);
            return;
        }
        this.source.subscribe(new FlattenIterableSubscriber<T, R>(s, this.mapper, this.prefetch, this.queueSupplier));
    }

    static final class FlattenIterableSubscriber<T, R>
    implements Subscriber<T>,
    Fuseable.QueueSubscription<R> {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Iterable<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final Supplier<Queue<T>> queueSupplier;
        volatile int wip;
        static final AtomicIntegerFieldUpdater<FlattenIterableSubscriber> WIP = AtomicIntegerFieldUpdater.newUpdater(FlattenIterableSubscriber.class, "wip");
        volatile long requested;
        static final AtomicLongFieldUpdater<FlattenIterableSubscriber> REQUESTED = AtomicLongFieldUpdater.newUpdater(FlattenIterableSubscriber.class, "requested");
        Subscription s;
        Queue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<FlattenIterableSubscriber, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(FlattenIterableSubscriber.class, Throwable.class, "error");
        Iterator<? extends R> current;
        int consumed;
        int fusionMode;

        public FlattenIterableSubscriber(Subscriber<? super R> actual, Function<? super T, ? extends Iterable<? extends R>> mapper, int prefetch, Supplier<Queue<T>> queueSupplier) {
            this.actual = actual;
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.queueSupplier = queueSupplier;
            this.limit = prefetch - (prefetch >> 2);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription qs = (Fuseable.QueueSubscription)s;
                    int m = qs.requestFusion(3);
                    if (m == 1) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.done = true;
                        this.actual.onSubscribe((Subscription)this);
                        return;
                    }
                    if (m == 2) {
                        this.fusionMode = m;
                        this.queue = qs;
                        this.actual.onSubscribe((Subscription)this);
                        s.request((long)this.prefetch);
                        return;
                    }
                }
                try {
                    this.queue = this.queueSupplier.get();
                }
                catch (Throwable ex) {
                    Operators.error(this.actual, Operators.onOperatorError(s, ex));
                    return;
                }
                this.actual.onSubscribe((Subscription)this);
                s.request((long)this.prefetch);
            }
        }

        public void onNext(T t) {
            if (this.fusionMode != 2 && !this.queue.offer(t)) {
                this.onError(Exceptions.failWithOverflow("Queue is full?!"));
                return;
            }
            this.drain();
        }

        public void onError(Throwable t) {
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.drain();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.s.cancel();
                if (WIP.getAndIncrement(this) == 0) {
                    this.queue.clear();
                }
            }
        }

        void drainAsync() {
            Subscriber<? super R> a = this.actual;
            Queue<T> q = this.queue;
            int missed = 1;
            Iterator<Object> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    Throwable ex = this.error;
                    if (ex != null) {
                        ex = Exceptions.terminate(ERROR, this);
                        this.current = null;
                        q.clear();
                        a.onError(ex);
                        return;
                    }
                    boolean d = this.done;
                    T t = q.poll();
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (!empty) {
                        boolean b;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t);
                            it = iterable.iterator();
                            b = it.hasNext();
                        }
                        catch (Throwable exc) {
                            it = null;
                            this.onError(Operators.onOperatorError(this.s, exc, t));
                            continue;
                        }
                        if (!b) {
                            it = null;
                            int c = this.consumed + 1;
                            if (c == this.limit) {
                                this.consumed = 0;
                                this.s.request((long)c);
                                continue;
                            }
                            this.consumed = c;
                            continue;
                        }
                    }
                }
                if (it != null) {
                    Throwable ex;
                    long r = this.requested;
                    long e = 0L;
                    while (e != r) {
                        boolean b;
                        R v;
                        if (this.cancelled) {
                            this.current = null;
                            q.clear();
                            return;
                        }
                        ex = this.error;
                        if (ex != null) {
                            ex = Exceptions.terminate(ERROR, this);
                            this.current = null;
                            q.clear();
                            a.onError(ex);
                            return;
                        }
                        try {
                            v = it.next();
                        }
                        catch (Throwable exc) {
                            this.onError(Operators.onOperatorError(this.s, exc));
                            continue;
                        }
                        a.onNext(v);
                        if (this.cancelled) {
                            this.current = null;
                            q.clear();
                            return;
                        }
                        ++e;
                        try {
                            b = it.hasNext();
                        }
                        catch (Throwable exc) {
                            this.onError(Operators.onOperatorError(this.s, exc));
                            continue;
                        }
                        if (b) continue;
                        int c = this.consumed + 1;
                        if (c == this.limit) {
                            this.consumed = 0;
                            this.s.request((long)c);
                        } else {
                            this.consumed = c;
                        }
                        it = null;
                        this.current = null;
                        break;
                    }
                    if (e == r) {
                        if (this.cancelled) {
                            this.current = null;
                            q.clear();
                            return;
                        }
                        ex = this.error;
                        if (ex != null) {
                            ex = Exceptions.terminate(ERROR, this);
                            this.current = null;
                            q.clear();
                            a.onError(ex);
                            return;
                        }
                        boolean d = this.done;
                        boolean empty = q.isEmpty();
                        if (d && empty) {
                            this.current = null;
                            a.onComplete();
                            return;
                        }
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        REQUESTED.addAndGet(this, -e);
                    }
                    if (it == null) continue;
                }
                this.current = it;
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        void drainSync() {
            Subscriber<? super R> a = this.actual;
            int missed = 1;
            Iterator<Object> it = this.current;
            while (true) {
                if (it == null) {
                    boolean empty;
                    if (this.cancelled) {
                        this.queue.clear();
                        return;
                    }
                    boolean d = this.done;
                    T t = this.queue.poll();
                    boolean bl = empty = t == null;
                    if (d && empty) {
                        a.onComplete();
                        return;
                    }
                    if (!empty) {
                        boolean b;
                        try {
                            Iterable<R> iterable = this.mapper.apply(t);
                            it = iterable.iterator();
                            b = it.hasNext();
                        }
                        catch (Throwable exc) {
                            this.current = null;
                            a.onError(Operators.onOperatorError(this.s, exc, t));
                            return;
                        }
                        if (!b) {
                            it = null;
                            continue;
                        }
                    }
                }
                if (it != null) {
                    long e;
                    long r = this.requested;
                    for (e = 0L; e != r; ++e) {
                        R v;
                        if (this.cancelled) {
                            this.current = null;
                            this.queue.clear();
                            return;
                        }
                        try {
                            v = it.next();
                        }
                        catch (Throwable exc) {
                            this.current = null;
                            a.onError(Operators.onOperatorError(this.s, exc));
                            return;
                        }
                        a.onNext(v);
                        if (this.cancelled) {
                            this.current = null;
                            this.queue.clear();
                            return;
                        }
                        try {
                            boolean b = it.hasNext();
                            continue;
                        }
                        catch (Throwable exc) {
                            this.onError(Operators.onOperatorError(this.s, exc));
                            continue;
                        }
                    }
                    if (e == r) {
                        boolean empty;
                        if (this.cancelled) {
                            this.current = null;
                            this.queue.clear();
                            return;
                        }
                        boolean d = this.done;
                        boolean bl = empty = this.queue.isEmpty() && it == null;
                        if (d && empty) {
                            this.current = null;
                            a.onComplete();
                            return;
                        }
                    }
                    if (e != 0L && r != Long.MAX_VALUE) {
                        REQUESTED.addAndGet(this, -e);
                    }
                    if (it == null) continue;
                }
                this.current = it;
                if ((missed = WIP.addAndGet(this, -missed)) == 0) break;
            }
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            if (this.fusionMode == 1) {
                this.drainSync();
            } else {
                this.drainAsync();
            }
        }

        @Override
        public void clear() {
            this.current = null;
            this.queue.clear();
        }

        @Override
        public boolean isEmpty() {
            Iterator<R> it = this.current;
            if (it != null) {
                return it.hasNext();
            }
            return this.queue.isEmpty();
        }

        @Override
        public R poll() {
            Iterator<R> it = this.current;
            while (it == null) {
                T v = this.queue.poll();
                if (v == null) {
                    return null;
                }
                it = this.mapper.apply(v).iterator();
                if (!it.hasNext()) continue;
                this.current = it;
                break;
            }
            R r = it.next();
            if (!it.hasNext()) {
                this.current = null;
            }
            return r;
        }

        @Override
        public int requestFusion(int requestedMode) {
            if ((requestedMode & 1) != 0 && this.fusionMode == 1) {
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.queue.size();
        }
    }
}

