/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Exceptions;
import reactor.core.Fuseable;
import reactor.core.MultiReceiver;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SpscFreeListTracker;
import reactor.core.publisher.SuppressFuseableSubscriber;

final class FluxFlatMap<T, R>
extends FluxSource<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final boolean delayError;
    final int maxConcurrency;
    final Supplier<? extends Queue<R>> mainQueueSupplier;
    final int prefetch;
    final Supplier<? extends Queue<R>> innerQueueSupplier;

    public FluxFlatMap(Publisher<? extends T> source, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, Supplier<? extends Queue<R>> mainQueueSupplier, int prefetch, Supplier<? extends Queue<R>> innerQueueSupplier) {
        super(source);
        if (prefetch <= 0) {
            throw new IllegalArgumentException("prefetch > 0 required but it was " + prefetch);
        }
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        this.mapper = Objects.requireNonNull(mapper, "mapper");
        this.delayError = delayError;
        this.prefetch = prefetch;
        this.maxConcurrency = maxConcurrency;
        this.mainQueueSupplier = Objects.requireNonNull(mainQueueSupplier, "mainQueueSupplier");
        this.innerQueueSupplier = Objects.requireNonNull(innerQueueSupplier, "innerQueueSupplier");
    }

    @Override
    public long getPrefetch() {
        return this.prefetch;
    }

    public static <T, R> Subscriber<T> subscriber(Subscriber<? super R> s, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, Supplier<? extends Queue<R>> mainQueueSupplier, int prefetch, Supplier<? extends Queue<R>> innerQueueSupplier) {
        return new FlatMapMain<T, R>(s, mapper, delayError, maxConcurrency, mainQueueSupplier, prefetch, innerQueueSupplier);
    }

    @Override
    public void subscribe(Subscriber<? super R> s) {
        if (FluxFlatMap.trySubscribeScalarMap(this.source, s, this.mapper, false)) {
            return;
        }
        this.source.subscribe(new FlatMapMain<T, R>(s, this.mapper, this.delayError, this.maxConcurrency, this.mainQueueSupplier, this.prefetch, this.innerQueueSupplier));
    }

    static <T, R> boolean trySubscribeScalarMap(Publisher<? extends T> source, Subscriber<? super R> s, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean fuseableExpected) {
        if (source instanceof Callable) {
            Publisher<? extends R> p;
            Object t;
            try {
                t = ((Callable)source).call();
            }
            catch (Throwable e) {
                Operators.error(s, Operators.onOperatorError(e));
                return true;
            }
            if (t == null) {
                Operators.complete(s);
                return true;
            }
            try {
                p = mapper.apply(t);
            }
            catch (Throwable e) {
                Operators.error(s, Operators.onOperatorError(e));
                return true;
            }
            if (p == null) {
                Operators.error(s, new NullPointerException("The mapper returned a null Publisher"));
                return true;
            }
            if (p instanceof Callable) {
                Object v;
                try {
                    v = ((Callable)p).call();
                }
                catch (Throwable e) {
                    Operators.error(s, Operators.onOperatorError(e));
                    return true;
                }
                if (v != null) {
                    s.onSubscribe(new Operators.ScalarSubscription<R>(s, v));
                } else {
                    Operators.complete(s);
                }
            } else if (!fuseableExpected || p instanceof Fuseable) {
                p.subscribe(s);
            } else {
                p.subscribe(new SuppressFuseableSubscriber<R>(s));
            }
            return true;
        }
        return false;
    }

    static final class FlatMapInner<R>
    implements Subscriber<R>,
    Subscription,
    Producer,
    Receiver,
    Trackable {
        final FlatMapMain<?, R> parent;
        final int prefetch;
        final int limit;
        volatile Subscription s;
        static final AtomicReferenceFieldUpdater<FlatMapInner, Subscription> S = AtomicReferenceFieldUpdater.newUpdater(FlatMapInner.class, Subscription.class, "s");
        long produced;
        volatile Queue<R> queue;
        volatile boolean done;
        int sourceMode;
        volatile int once;
        static final AtomicIntegerFieldUpdater<FlatMapInner> ONCE = AtomicIntegerFieldUpdater.newUpdater(FlatMapInner.class, "once");
        int index;

        public FlatMapInner(FlatMapMain<?, R> parent, int prefetch) {
            this.parent = parent;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
        }

        public void onSubscribe(Subscription s) {
            if (Operators.setOnce(S, this, s)) {
                if (s instanceof Fuseable.QueueSubscription) {
                    Fuseable.QueueSubscription f = (Fuseable.QueueSubscription)s;
                    int m = f.requestFusion(3);
                    if (m == 1) {
                        this.sourceMode = 1;
                        this.queue = f;
                        this.done = true;
                        this.parent.drain();
                        return;
                    }
                    if (m == 2) {
                        this.sourceMode = 2;
                        this.queue = f;
                    }
                }
                s.request((long)this.prefetch);
            }
        }

        public void onNext(R t) {
            if (this.sourceMode == 2) {
                this.parent.drain();
            } else {
                this.parent.innerNext(this, t);
            }
        }

        public void onError(Throwable t) {
            if (this.sourceMode != 2 || ONCE.compareAndSet(this, 0, 1)) {
                this.parent.innerError(this, t);
            }
        }

        public void onComplete() {
            this.done = true;
            this.parent.innerComplete(this);
        }

        public void request(long n) {
            if (this.sourceMode != 1) {
                long p = this.produced + n;
                if (p >= (long)this.limit) {
                    this.produced = 0L;
                    this.s.request(p);
                } else {
                    this.produced = p;
                }
            }
        }

        public void cancel() {
            Operators.terminate(S, this);
        }

        @Override
        public long getCapacity() {
            return this.prefetch;
        }

        @Override
        public long getPending() {
            return this.done || this.queue == null ? -1L : (long)this.queue.size();
        }

        @Override
        public boolean isCancelled() {
            return this.s == Operators.cancelledSubscription();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done && !this.isCancelled();
        }

        @Override
        public boolean isTerminated() {
            return this.done && (this.queue == null || this.queue.isEmpty());
        }

        @Override
        public long expectedFromUpstream() {
            return this.produced;
        }

        @Override
        public long limit() {
            return this.limit;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Object downstream() {
            return this.parent;
        }
    }

    static final class FlatMapMain<T, R>
    extends SpscFreeListTracker<FlatMapInner<R>>
    implements Subscriber<T>,
    Subscription,
    Receiver,
    MultiReceiver,
    Producer,
    Trackable {
        final Subscriber<? super R> actual;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final boolean delayError;
        final int maxConcurrency;
        final Supplier<? extends Queue<R>> mainQueueSupplier;
        final int prefetch;
        final Supplier<? extends Queue<R>> innerQueueSupplier;
        final int limit;
        volatile Queue<R> scalarQueue;
        volatile Throwable error;
        static final AtomicReferenceFieldUpdater<FlatMapMain, Throwable> ERROR = AtomicReferenceFieldUpdater.newUpdater(FlatMapMain.class, Throwable.class, "error");
        volatile boolean done;
        volatile boolean cancelled;
        Subscription s;
        volatile long requested;
        static final AtomicLongFieldUpdater<FlatMapMain> REQUESTED = AtomicLongFieldUpdater.newUpdater(FlatMapMain.class, "requested");
        volatile int wip;
        static final AtomicIntegerFieldUpdater<FlatMapMain> WIP = AtomicIntegerFieldUpdater.newUpdater(FlatMapMain.class, "wip");
        static final FlatMapInner[] EMPTY = new FlatMapInner[0];
        static final FlatMapInner[] TERMINATED = new FlatMapInner[0];
        int lastIndex;
        int produced;

        public FlatMapMain(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, boolean delayError, int maxConcurrency, Supplier<? extends Queue<R>> mainQueueSupplier, int prefetch, Supplier<? extends Queue<R>> innerQueueSupplier) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayError = delayError;
            this.maxConcurrency = maxConcurrency;
            this.mainQueueSupplier = mainQueueSupplier;
            this.prefetch = prefetch;
            this.innerQueueSupplier = innerQueueSupplier;
            this.limit = maxConcurrency - (maxConcurrency >> 2);
        }

        protected FlatMapInner<R>[] empty() {
            return EMPTY;
        }

        protected FlatMapInner<R>[] terminated() {
            return TERMINATED;
        }

        protected FlatMapInner<R>[] newArray(int size) {
            return new FlatMapInner[size];
        }

        @Override
        protected void setIndex(FlatMapInner<R> entry, int index) {
            entry.index = index;
        }

        @Override
        protected void unsubscribeEntry(FlatMapInner<R> entry) {
            entry.cancel();
        }

        public void request(long n) {
            if (Operators.validate(n)) {
                Operators.getAndAddCap(REQUESTED, this, n);
                this.drain();
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                if (WIP.getAndIncrement(this) == 0) {
                    this.scalarQueue = null;
                    this.s.cancel();
                    this.unsubscribe();
                }
            }
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe((Subscription)this);
                if (this.maxConcurrency == Integer.MAX_VALUE) {
                    s.request(Long.MAX_VALUE);
                } else {
                    s.request((long)this.maxConcurrency);
                }
            }
        }

        public void onNext(T t) {
            Publisher<? extends R> p;
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            try {
                p = this.mapper.apply(t);
            }
            catch (Throwable e) {
                this.onError(Operators.onOperatorError(this.s, e, t));
                return;
            }
            if (p == null) {
                this.onError(Operators.onOperatorError(this.s, new NullPointerException("The mapper returned a null Publisher"), t));
                return;
            }
            if (p instanceof Callable) {
                Object v;
                try {
                    v = ((Callable)p).call();
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                this.emitScalar(v);
            } else {
                FlatMapInner inner = new FlatMapInner(this, this.prefetch);
                if (this.add(inner)) {
                    p.subscribe(inner);
                }
            }
        }

        void emitScalar(R v) {
            if (v == null) {
                if (this.maxConcurrency != Integer.MAX_VALUE) {
                    int p = this.produced + 1;
                    if (p == this.limit) {
                        this.produced = 0;
                        this.s.request((long)p);
                    } else {
                        this.produced = p;
                    }
                }
                return;
            }
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != 0L) {
                    this.actual.onNext(v);
                    if (r != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                    if (this.maxConcurrency != Integer.MAX_VALUE) {
                        int p = this.produced + 1;
                        if (p == this.limit) {
                            this.produced = 0;
                            this.s.request((long)p);
                        } else {
                            this.produced = p;
                        }
                    }
                } else {
                    Queue<R> q;
                    try {
                        q = this.getOrCreateScalarQueue();
                    }
                    catch (Throwable ex) {
                        ex = Operators.onOperatorError(this.s, ex, v);
                        if (Exceptions.addThrowable(ERROR, this, ex)) {
                            this.done = true;
                        } else {
                            Operators.onErrorDropped(ex);
                        }
                        this.drainLoop();
                        return;
                    }
                    if (!q.offer(v)) {
                        this.s.cancel();
                        IllegalStateException e = Exceptions.failWithOverflow("Scalar queue full?!");
                        if (Exceptions.addThrowable(ERROR, this, e)) {
                            this.done = true;
                        } else {
                            Operators.onErrorDropped(e);
                        }
                        this.drainLoop();
                        return;
                    }
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                Queue<R> q;
                try {
                    q = this.getOrCreateScalarQueue();
                }
                catch (Throwable ex) {
                    ex = Operators.onOperatorError(this.s, ex, v);
                    if (Exceptions.addThrowable(ERROR, this, ex)) {
                        this.done = true;
                    } else {
                        Operators.onErrorDropped(ex);
                    }
                    this.drain();
                    return;
                }
                if (!q.offer(v)) {
                    this.s.cancel();
                    IllegalStateException e = Exceptions.failWithOverflow("Scalar queue full?!");
                    if (Exceptions.addThrowable(ERROR, this, e)) {
                        this.done = true;
                    } else {
                        Operators.onErrorDropped(e);
                    }
                }
                this.drain();
            }
        }

        Queue<R> getOrCreateScalarQueue() {
            Queue<R> q = this.scalarQueue;
            if (q == null) {
                this.scalarQueue = q = this.mainQueueSupplier.get();
            }
            return q;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            if (Exceptions.addThrowable(ERROR, this, t)) {
                this.done = true;
                this.drain();
            } else {
                Operators.onErrorDropped(t);
            }
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        }

        void drainLoop() {
            boolean again;
            int missed = 1;
            Subscriber<? super R> a = this.actual;
            do {
                long e;
                boolean d = this.done;
                FlatMapInner[] as = (FlatMapInner[])this.get();
                int n = as.length;
                Queue<R> sq = this.scalarQueue;
                boolean noSources = this.isEmpty();
                if (this.checkTerminated(d, noSources && (sq == null || sq.isEmpty()), a)) {
                    return;
                }
                again = false;
                long r = this.requested;
                long replenishMain = 0L;
                if (r != 0L && sq != null) {
                    for (e = 0L; e != r; ++e) {
                        boolean empty;
                        d = this.done;
                        R v = sq.poll();
                        boolean bl = empty = v == null;
                        if (this.checkTerminated(d, false, a)) {
                            return;
                        }
                        if (empty) break;
                        a.onNext(v);
                    }
                    if (e != 0L) {
                        replenishMain += e;
                        if (r != Long.MAX_VALUE) {
                            r = REQUESTED.addAndGet(this, -e);
                        }
                        e = 0L;
                        again = true;
                    }
                }
                if (r != 0L && !noSources) {
                    int j = this.lastIndex;
                    if (j >= n) {
                        j = 0;
                    }
                    for (int i = 0; i < n; ++i) {
                        if (this.cancelled) {
                            this.scalarQueue = null;
                            this.s.cancel();
                            this.unsubscribe();
                            return;
                        }
                        FlatMapInner inner = as[j];
                        if (inner != null) {
                            d = inner.done;
                            Queue q = inner.queue;
                            if (d && q == null) {
                                this.remove(inner.index);
                                again = true;
                                ++replenishMain;
                            } else if (q != null) {
                                while (e != r) {
                                    boolean empty;
                                    Object v;
                                    d = inner.done;
                                    try {
                                        v = q.poll();
                                    }
                                    catch (Throwable ex) {
                                        ex = Operators.onOperatorError(inner, ex);
                                        if (!Exceptions.addThrowable(ERROR, this, ex)) {
                                            Operators.onErrorDropped(ex);
                                        }
                                        v = null;
                                        d = true;
                                    }
                                    boolean bl = empty = v == null;
                                    if (this.checkTerminated(d, false, a)) {
                                        return;
                                    }
                                    if (d && empty) {
                                        this.remove(inner.index);
                                        again = true;
                                        ++replenishMain;
                                        break;
                                    }
                                    if (empty) break;
                                    a.onNext(v);
                                    ++e;
                                }
                                if (e == r) {
                                    boolean empty;
                                    d = inner.done;
                                    try {
                                        empty = q.isEmpty();
                                    }
                                    catch (Throwable ex) {
                                        ex = Operators.onOperatorError(inner, ex);
                                        if (!Exceptions.addThrowable(ERROR, this, ex)) {
                                            Operators.onErrorDropped(ex);
                                        }
                                        empty = true;
                                        d = true;
                                    }
                                    if (d && empty) {
                                        this.remove(inner.index);
                                        again = true;
                                        ++replenishMain;
                                    }
                                }
                                if (e != 0L) {
                                    if (!inner.done) {
                                        inner.request(e);
                                    }
                                    if (r != Long.MAX_VALUE && (r = REQUESTED.addAndGet(this, -e)) == 0L) break;
                                    e = 0L;
                                }
                            }
                        }
                        if (r == 0L) break;
                        if (++j != n) continue;
                        j = 0;
                    }
                    this.lastIndex = j;
                }
                if (r == 0L && !noSources) {
                    as = (FlatMapInner[])this.get();
                    n = as.length;
                    for (int i = 0; i < n; ++i) {
                        boolean empty;
                        if (this.cancelled) {
                            this.scalarQueue = null;
                            this.s.cancel();
                            this.unsubscribe();
                            return;
                        }
                        FlatMapInner inner = as[i];
                        if (inner == null) continue;
                        d = inner.done;
                        Queue q = inner.queue;
                        boolean bl = empty = q == null || q.isEmpty();
                        if (!empty) break;
                        if (!d || !empty) continue;
                        this.remove(inner.index);
                        again = true;
                        ++replenishMain;
                    }
                }
                if (replenishMain == 0L || this.done || this.cancelled) continue;
                this.s.request(replenishMain);
            } while (again || (missed = WIP.addAndGet(this, -missed)) != 0);
        }

        boolean checkTerminated(boolean d, boolean empty, Subscriber<?> a) {
            if (this.cancelled) {
                this.scalarQueue = null;
                this.s.cancel();
                this.unsubscribe();
                return true;
            }
            if (this.delayError) {
                if (d && empty) {
                    Throwable e = this.error;
                    if (e != null && e != Exceptions.TERMINATED) {
                        e = Exceptions.terminate(ERROR, this);
                        a.onError(e);
                    } else {
                        a.onComplete();
                    }
                    return true;
                }
            } else if (d) {
                Throwable e = this.error;
                if (e != null && e != Exceptions.TERMINATED) {
                    e = Exceptions.terminate(ERROR, this);
                    this.scalarQueue = null;
                    this.s.cancel();
                    this.unsubscribe();
                    a.onError(e);
                    return true;
                }
                if (empty) {
                    a.onComplete();
                    return true;
                }
            }
            return false;
        }

        void innerError(FlatMapInner<R> inner, Throwable e) {
            if (Exceptions.addThrowable(ERROR, this, e)) {
                inner.done = true;
                if (!this.delayError) {
                    this.done = true;
                }
                this.drain();
            } else {
                Operators.onErrorDropped(e);
            }
        }

        void innerNext(FlatMapInner<R> inner, R v) {
            if (this.wip == 0 && WIP.compareAndSet(this, 0, 1)) {
                long r = this.requested;
                if (r != 0L) {
                    this.actual.onNext(v);
                    if (r != Long.MAX_VALUE) {
                        REQUESTED.decrementAndGet(this);
                    }
                    inner.request(1L);
                } else {
                    Queue<R> q;
                    try {
                        q = this.getOrCreateScalarQueue(inner);
                    }
                    catch (Throwable ex) {
                        ex = Operators.onOperatorError(inner, ex, v);
                        if (Exceptions.addThrowable(ERROR, this, ex)) {
                            inner.done = true;
                        } else {
                            Operators.onErrorDropped(ex);
                        }
                        this.drainLoop();
                        return;
                    }
                    if (!q.offer(v)) {
                        inner.cancel();
                        Throwable e = Operators.onOperatorError(inner, Exceptions.failWithOverflow("Scalar queue full?!"), v);
                        if (Exceptions.addThrowable(ERROR, this, e)) {
                            inner.done = true;
                        } else {
                            Operators.onErrorDropped(e);
                        }
                        this.drainLoop();
                        return;
                    }
                }
                if (WIP.decrementAndGet(this) == 0) {
                    return;
                }
                this.drainLoop();
            } else {
                Queue<R> q;
                try {
                    q = this.getOrCreateScalarQueue(inner);
                }
                catch (Throwable ex) {
                    ex = Operators.onOperatorError(inner, ex, v);
                    if (Exceptions.addThrowable(ERROR, this, ex)) {
                        inner.done = true;
                    } else {
                        Operators.onErrorDropped(ex);
                    }
                    this.drain();
                    return;
                }
                if (!q.offer(v)) {
                    Throwable e = Operators.onOperatorError(inner, Exceptions.failWithOverflow("Scalar queue full?!"), v);
                    if (Exceptions.addThrowable(ERROR, this, e)) {
                        inner.done = true;
                    } else {
                        Operators.onErrorDropped(e);
                    }
                }
                this.drain();
            }
        }

        void innerComplete(FlatMapInner<R> inner) {
            if (WIP.getAndIncrement(this) != 0) {
                return;
            }
            this.drainLoop();
        }

        Queue<R> getOrCreateScalarQueue(FlatMapInner<R> inner) {
            Queue q = inner.queue;
            if (q == null) {
                inner.queue = q = this.innerQueueSupplier.get();
            }
            return q;
        }

        @Override
        public long getCapacity() {
            return this.maxConcurrency;
        }

        @Override
        public long getPending() {
            return this.done || this.scalarQueue == null ? -1L : (long)this.scalarQueue.size();
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.isTerminated() && !this.isCancelled();
        }

        @Override
        public boolean isTerminated() {
            return this.done && ((FlatMapInner[])this.get()).length == 0;
        }

        @Override
        public Throwable getError() {
            return this.error;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        @Override
        public Iterator<?> upstreams() {
            return Arrays.asList(this.get()).iterator();
        }

        @Override
        public long upstreamCount() {
            return ((FlatMapInner[])this.get()).length;
        }

        @Override
        public long requestedFromDownstream() {
            return this.requested;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }
    }
}

