/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.function.Predicate;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.Loopback;
import reactor.core.Producer;
import reactor.core.Receiver;
import reactor.core.Trackable;
import reactor.core.publisher.FluxSource;
import reactor.core.publisher.Operators;

final class FluxFilterFuseable<T>
extends FluxSource<T, T>
implements Fuseable {
    final Predicate<? super T> predicate;

    public FluxFilterFuseable(Publisher<? extends T> source, Predicate<? super T> predicate) {
        super(source);
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    public Predicate<? super T> predicate() {
        return this.predicate;
    }

    @Override
    public void subscribe(Subscriber<? super T> s) {
        if (s instanceof Fuseable.ConditionalSubscriber) {
            this.source.subscribe(new FilterFuseableConditionalSubscriber<T>((Fuseable.ConditionalSubscriber)s, this.predicate));
            return;
        }
        this.source.subscribe(new FilterFuseableSubscriber<T>(s, this.predicate));
    }

    static final class FilterFuseableConditionalSubscriber<T>
    implements Receiver,
    Producer,
    Loopback,
    Fuseable.ConditionalSubscriber<T>,
    Fuseable.SynchronousSubscription<T>,
    Trackable {
        final Fuseable.ConditionalSubscriber<? super T> actual;
        final Predicate<? super T> predicate;
        Fuseable.QueueSubscription<T> s;
        boolean done;
        int sourceMode;

        public FilterFuseableConditionalSubscriber(Fuseable.ConditionalSubscriber<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe(this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (b) {
                    this.actual.onNext(t);
                } else {
                    this.s.request(1L);
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            int m = this.sourceMode;
            if (m == 0) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
                return b && this.actual.tryOnNext(t);
            }
            if (m == 2) {
                this.actual.onNext(null);
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.predicate;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public T poll() {
            Object v;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) == null || this.predicate.test(v2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            while ((v = this.s.poll()) != null && !this.predicate.test(v)) {
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? 0 : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }
    }

    static final class FilterFuseableSubscriber<T>
    implements Receiver,
    Producer,
    Loopback,
    Fuseable.SynchronousSubscription<T>,
    Fuseable.ConditionalSubscriber<T>,
    Trackable {
        final Subscriber<? super T> actual;
        final Predicate<? super T> predicate;
        Fuseable.QueueSubscription<T> s;
        boolean done;
        int sourceMode;

        public FilterFuseableSubscriber(Subscriber<? super T> actual, Predicate<? super T> predicate) {
            this.actual = actual;
            this.predicate = predicate;
        }

        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = (Fuseable.QueueSubscription)s;
                this.actual.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return;
            }
            int m = this.sourceMode;
            if (m == 0) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return;
                }
                if (b) {
                    this.actual.onNext(t);
                } else {
                    this.s.request(1L);
                }
            } else if (m == 2) {
                this.actual.onNext(null);
            }
        }

        @Override
        public boolean tryOnNext(T t) {
            if (this.done) {
                Operators.onNextDropped(t);
                return false;
            }
            int m = this.sourceMode;
            if (m == 0) {
                boolean b;
                try {
                    b = this.predicate.test(t);
                }
                catch (Throwable e) {
                    this.onError(Operators.onOperatorError(this.s, e, t));
                    return false;
                }
                if (b) {
                    this.actual.onNext(t);
                    return true;
                }
                return false;
            }
            if (m == 2) {
                this.actual.onNext(null);
            }
            return true;
        }

        public void onError(Throwable t) {
            if (this.done) {
                Operators.onErrorDropped(t);
                return;
            }
            this.done = true;
            this.actual.onError(t);
        }

        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.actual.onComplete();
        }

        @Override
        public boolean isStarted() {
            return this.s != null && !this.done;
        }

        @Override
        public boolean isTerminated() {
            return this.done;
        }

        @Override
        public Object downstream() {
            return this.actual;
        }

        @Override
        public Object connectedInput() {
            return this.predicate;
        }

        @Override
        public Object upstream() {
            return this.s;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
        }

        @Override
        public T poll() {
            Object v;
            if (this.sourceMode == 2) {
                long dropped = 0L;
                while (true) {
                    Object v2;
                    if ((v2 = this.s.poll()) == null || this.predicate.test(v2)) {
                        if (dropped != 0L) {
                            this.request(dropped);
                        }
                        return (T)v2;
                    }
                    ++dropped;
                }
            }
            while ((v = this.s.poll()) != null && !this.predicate.test(v)) {
            }
            return (T)v;
        }

        @Override
        public boolean isEmpty() {
            return this.s.isEmpty();
        }

        @Override
        public void clear() {
            this.s.clear();
        }

        @Override
        public int requestFusion(int requestedMode) {
            int m = (requestedMode & 4) != 0 ? 0 : this.s.requestFusion(requestedMode);
            this.sourceMode = m;
            return m;
        }

        @Override
        public int size() {
            return this.s.size();
        }
    }
}

