/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Trackable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Operators;

final class FluxError<T>
extends Flux<T>
implements Trackable {
    final Supplier<? extends Throwable> supplier;
    final boolean whenRequested;

    public FluxError(Throwable error, boolean whenRequested) {
        this(FluxError.create(error), whenRequested);
    }

    static Supplier<Throwable> create(Throwable error) {
        Objects.requireNonNull(error);
        return () -> error;
    }

    public FluxError(Supplier<? extends Throwable> supplier, boolean whenRequested) {
        this.supplier = Objects.requireNonNull(supplier);
        this.whenRequested = whenRequested;
    }

    @Override
    public Throwable getError() {
        return this.supplier.get();
    }

    public void subscribe(Subscriber<? super T> s) {
        Throwable e;
        try {
            e = this.supplier.get();
        }
        catch (Throwable ex) {
            e = ex;
        }
        if (e == null) {
            e = new NullPointerException("The Throwable returned by the supplier is null");
        }
        if (this.whenRequested) {
            s.onSubscribe((Subscription)new ErrorSubscription(s, e));
        } else {
            Operators.error(s, Operators.onOperatorError(e));
        }
    }

    static final class ErrorSubscription
    implements Subscription {
        final Subscriber<?> actual;
        final Throwable error;
        volatile int once;
        static final AtomicIntegerFieldUpdater<ErrorSubscription> ONCE = AtomicIntegerFieldUpdater.newUpdater(ErrorSubscription.class, "once");

        public ErrorSubscription(Subscriber<?> actual, Throwable error) {
            this.actual = actual;
            this.error = error;
        }

        public void request(long n) {
            if (Operators.validate(n) && ONCE.compareAndSet(this, 0, 1)) {
                this.actual.onError(this.error);
            }
        }

        public void cancel() {
            this.once = 1;
        }
    }
}

